/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.util;

import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.AxiomImpl;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import cz.cvut.kbss.ontodriver.rdf4j.util.ValueConverter;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;

public class AxiomBuilder {
    private final NamedResource subject;
    private final Map<IRI, Assertion> propertyToAssertion;
    private final Assertion unspecifiedProperty;

    public AxiomBuilder(NamedResource subject, Map<IRI, Assertion> propertyToAssertion, Assertion unspecifiedProperty) {
        this.subject = subject;
        this.propertyToAssertion = propertyToAssertion;
        this.unspecifiedProperty = unspecifiedProperty;
    }

    public Axiom<?> statementToAxiom(Statement statement) {
        Assertion assertion = this.resolveAssertion(statement.getPredicate());
        return this.statementToAxiom(statement, assertion);
    }

    private static Optional<Value<?>> resolveValue(Statement stmt, Assertion assertion) {
        if (assertion == null || Rdf4jUtils.isBlankNode(stmt.getObject())) {
            return Optional.empty();
        }
        return AxiomBuilder.createValue(assertion, stmt.getObject());
    }

    public Axiom<?> statementToAxiom(Statement statement, Assertion assertion) {
        Optional<Value<?>> val = AxiomBuilder.resolveValue(statement, assertion);
        return val.map(v -> new AxiomImpl(this.subject, assertion, v)).orElse(null);
    }

    private Assertion resolveAssertion(IRI predicate) {
        Assertion assertion = this.propertyToAssertion.get(predicate);
        if (assertion == null) {
            if (this.unspecifiedProperty != null) {
                assertion = Assertion.createPropertyAssertion((URI)Rdf4jUtils.toJavaUri((Resource)predicate), (boolean)this.unspecifiedProperty.isInferred());
            }
        } else if (assertion.getType() == Assertion.AssertionType.PROPERTY) {
            assertion = Assertion.createPropertyAssertion((URI)Rdf4jUtils.toJavaUri((Resource)predicate), (boolean)assertion.isInferred());
        }
        return assertion;
    }

    private static Optional<Value<?>> createValue(Assertion assertion, org.eclipse.rdf4j.model.Value value) {
        return ValueConverter.fromRdf4jValue(assertion, value).map(Value::new);
    }
}

