/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.util;

import cz.cvut.kbss.jopa.datatype.xsd.XsdDatatypeMapper;
import cz.cvut.kbss.jopa.datatype.xsd.XsdTemporalMapper;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.LangString;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.util.IdentifierUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.slf4j.LoggerFactory;

public final class Rdf4jUtils {
    private Rdf4jUtils() {
    }

    public static Object getLiteralValue(Literal literal) {
        assert (literal != null);
        IRI datatype = literal.getDatatype();
        assert (datatype != null);
        if (datatype.equals((Object)RDF.LANGSTRING)) {
            return new LangString(literal.stringValue(), (String)literal.getLanguage().orElse(null));
        }
        cz.cvut.kbss.ontodriver.model.Literal lit = cz.cvut.kbss.ontodriver.model.Literal.from((String)literal.getLabel(), (String)datatype.stringValue());
        return XsdDatatypeMapper.getInstance().map(lit).orElse(lit);
    }

    public static boolean doesLanguageMatch(Literal literal, Assertion assertion) {
        assert (assertion != null);
        if (!assertion.hasLanguage()) {
            return true;
        }
        String language = assertion.getLanguage();
        IRI datatype = literal.getDatatype();
        if (datatype.equals((Object)XSD.STRING) || datatype.equals((Object)XSD.NORMALIZEDSTRING) || datatype.equals((Object)RDF.LANGSTRING)) {
            return language == null || literal.getLanguage().isEmpty() || ((String)literal.getLanguage().get()).equals(language);
        }
        return true;
    }

    public static Literal createLiteral(Object value, String language, ValueFactory vf) {
        assert (value != null);
        if (value instanceof Integer) {
            return vf.createLiteral(((Integer)value).intValue());
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return vf.createLiteral(c.toString());
        }
        if (value instanceof String) {
            return language != null ? vf.createLiteral((String)value, language) : vf.createLiteral((String)value);
        }
        if (value instanceof LangString) {
            LangString ls = (LangString)value;
            return ls.getLanguage().isPresent() ? vf.createLiteral(ls.getValue(), (String)ls.getLanguage().get()) : vf.createLiteral(ls.getValue());
        }
        if (value instanceof Byte) {
            return vf.createLiteral(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return vf.createLiteral(((Short)value).shortValue());
        }
        if (value instanceof Boolean) {
            return vf.createLiteral(((Boolean)value).booleanValue());
        }
        if (value instanceof Float) {
            return vf.createLiteral(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return vf.createLiteral(((Double)value).doubleValue());
        }
        if (value instanceof Long) {
            return vf.createLiteral(((Long)value).longValue());
        }
        if (value instanceof BigInteger) {
            return vf.createLiteral((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return vf.createLiteral((BigDecimal)value);
        }
        if (value instanceof Date) {
            cz.cvut.kbss.ontodriver.model.Literal ontoLiteral = XsdTemporalMapper.map((TemporalAccessor)((Date)value).toInstant());
            return Rdf4jUtils.createLiteral(vf, ontoLiteral);
        }
        if (value instanceof TemporalAccessor) {
            cz.cvut.kbss.ontodriver.model.Literal ontoLiteral = XsdTemporalMapper.map((TemporalAccessor)((TemporalAccessor)value));
            return Rdf4jUtils.createLiteral(vf, ontoLiteral);
        }
        if (value instanceof TemporalAmount) {
            cz.cvut.kbss.ontodriver.model.Literal ontoLiteral = XsdTemporalMapper.map((TemporalAmount)((TemporalAmount)value));
            return Rdf4jUtils.createLiteral(vf, ontoLiteral);
        }
        if (value.getClass().isEnum()) {
            return vf.createLiteral(value.toString());
        }
        if (value instanceof cz.cvut.kbss.ontodriver.model.Literal) {
            cz.cvut.kbss.ontodriver.model.Literal ontoLiteral = (cz.cvut.kbss.ontodriver.model.Literal)value;
            return Rdf4jUtils.createLiteral(vf, ontoLiteral);
        }
        throw new IllegalArgumentException("Unsupported literal type " + String.valueOf(value.getClass()));
    }

    private static Literal createLiteral(ValueFactory vf, cz.cvut.kbss.ontodriver.model.Literal ontoLiteral) {
        return vf.createLiteral(ontoLiteral.getLexicalForm(), vf.createIRI(ontoLiteral.getDatatype()));
    }

    public static boolean isBlankNode(Value value) {
        assert (value != null);
        return value instanceof BNode;
    }

    public static boolean isResourceIdentifier(Object value) {
        return value != null && IdentifierUtils.isResourceIdentifierType(value.getClass());
    }

    public static IRI toRdf4jIri(URI javaUri, ValueFactory factory) {
        return javaUri != null ? factory.createIRI(javaUri.toString()) : null;
    }

    public static IRI toRdf4jIri(NamedResource resource, ValueFactory factory) {
        return Rdf4jUtils.toRdf4jIri(resource.getIdentifier(), factory);
    }

    public static URI toJavaUri(Resource resource) {
        if (resource instanceof BNode) {
            return null;
        }
        try {
            return URI.create(resource.stringValue());
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(Rdf4jUtils.class).error("RDF4J resource is not a valid URI.", (Throwable)e);
            return null;
        }
    }
}

