/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.util;

import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.config.Constants;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;

public class ValueConverter {
    private final ValueFactory vf;

    public ValueConverter(ValueFactory vf) {
        this.vf = vf;
    }

    public static Optional<Object> fromRdf4jValue(Assertion assertion, org.eclipse.rdf4j.model.Value value) {
        Assertion.AssertionType assertionType = assertion.getType();
        return switch (assertionType) {
            default -> throw new IncompatibleClassChangeError();
            case Assertion.AssertionType.DATA_PROPERTY -> {
                if (!(value instanceof Literal) || !Rdf4jUtils.doesLanguageMatch((Literal)value, assertion)) {
                    yield Optional.empty();
                }
                yield Optional.of(Rdf4jUtils.getLiteralValue((Literal)value));
            }
            case Assertion.AssertionType.CLASS -> {
                if (!(value instanceof Resource)) {
                    yield Optional.empty();
                }
                yield Optional.ofNullable(Rdf4jUtils.toJavaUri((Resource)value));
            }
            case Assertion.AssertionType.OBJECT_PROPERTY -> {
                if (!(value instanceof Resource)) {
                    yield Optional.empty();
                }
                yield Optional.of(NamedResource.create((String)value.stringValue()));
            }
            case Assertion.AssertionType.ANNOTATION_PROPERTY, Assertion.AssertionType.PROPERTY -> ValueConverter.resolveUnknownPropertyTypeValue(assertion, value);
        };
    }

    private static Optional<Object> resolveUnknownPropertyTypeValue(Assertion assertion, org.eclipse.rdf4j.model.Value value) {
        if (value instanceof Literal) {
            if (!Rdf4jUtils.doesLanguageMatch((Literal)value, assertion)) {
                return Optional.empty();
            }
            return Optional.of(Rdf4jUtils.getLiteralValue((Literal)value));
        }
        return Optional.of(NamedResource.create((String)value.stringValue()));
    }

    public org.eclipse.rdf4j.model.Value toRdf4jValue(Assertion assertion, Value<?> val) throws Rdf4jDriverException {
        return this.toRdf4jValue(assertion, val.getValue());
    }

    public org.eclipse.rdf4j.model.Value toRdf4jValue(Assertion assertion, Object val) throws Rdf4jDriverException {
        return switch (assertion.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Assertion.AssertionType.DATA_PROPERTY -> Rdf4jUtils.createLiteral(val, ValueConverter.language(assertion), this.vf);
            case Assertion.AssertionType.CLASS, Assertion.AssertionType.OBJECT_PROPERTY -> this.getValueAsIri(val);
            case Assertion.AssertionType.ANNOTATION_PROPERTY, Assertion.AssertionType.PROPERTY -> this.resolvePropertyValue(assertion, val);
        };
    }

    private static String language(Assertion assertion) {
        return assertion.hasLanguage() ? assertion.getLanguage() : Constants.DEFAULT_LANG;
    }

    private IRI getValueAsIri(Object val) throws Rdf4jDriverException {
        try {
            return this.vf.createIRI(val.toString());
        }
        catch (IllegalArgumentException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    private org.eclipse.rdf4j.model.Value resolvePropertyValue(Assertion assertion, Object val) {
        if ((!(val instanceof String) || assertion.hasLanguage()) && Rdf4jUtils.isResourceIdentifier(val)) {
            return this.vf.createIRI(val.toString());
        }
        return Rdf4jUtils.createLiteral(val, ValueConverter.language(assertion), this.vf);
    }
}

