/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld;

import cz.cvut.kbss.jsonld.ConfigParam;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Configuration {
    private final Map<String, String> config = new HashMap<String, String>();

    public Configuration() {
    }

    public Configuration(Configuration other) {
        Objects.requireNonNull(other);
        this.config.putAll(other.config);
    }

    public String get(ConfigParam param) {
        Objects.requireNonNull(param);
        return this.get(param.getName());
    }

    public String get(String param) {
        return this.config.get(param);
    }

    public String get(ConfigParam param, String defaultValue) {
        Objects.requireNonNull(param);
        return this.config.getOrDefault(param.getName(), defaultValue);
    }

    public String get(String param, String defaultValue) {
        return this.config.getOrDefault(param, defaultValue);
    }

    public boolean is(ConfigParam param) {
        Objects.requireNonNull(param);
        return this.is(param.getName());
    }

    public boolean is(String param) {
        String value = this.get(param, Boolean.FALSE.toString());
        return Boolean.parseBoolean(value);
    }

    public void set(ConfigParam param, String value) {
        Objects.requireNonNull(param);
        this.config.put(param.getName(), value);
    }

    public void set(String param, String value) {
        Objects.requireNonNull(param);
        this.config.put(param, value);
    }

    public boolean has(String param) {
        return this.config.containsKey(param);
    }

    public boolean has(ConfigParam param) {
        return this.has(param.getName());
    }
}

