/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.common;

import cz.cvut.kbss.jopa.model.annotations.Id;
import cz.cvut.kbss.jopa.model.annotations.Namespace;
import cz.cvut.kbss.jopa.model.annotations.Namespaces;
import cz.cvut.kbss.jopa.model.annotations.OWLAnnotationProperty;
import cz.cvut.kbss.jopa.model.annotations.OWLClass;
import cz.cvut.kbss.jopa.model.annotations.OWLDataProperty;
import cz.cvut.kbss.jopa.model.annotations.OWLObjectProperty;
import cz.cvut.kbss.jopa.model.annotations.Properties;
import cz.cvut.kbss.jopa.model.annotations.Types;
import cz.cvut.kbss.jsonld.annotation.JsonLdAttributeOrder;
import cz.cvut.kbss.jsonld.common.IdentifierUtil;
import cz.cvut.kbss.jsonld.common.JsonLdPropertyAccessResolver;
import cz.cvut.kbss.jsonld.common.PropertyAccessResolver;
import cz.cvut.kbss.jsonld.exception.JsonLdSerializationException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BeanAnnotationProcessor {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final BiPredicate<Field, Class<?>> ALWAYS_TRUE = (f, cls) -> true;
    private static PropertyAccessResolver propertyAccessResolver = new JsonLdPropertyAccessResolver();

    private BeanAnnotationProcessor() {
        throw new AssertionError();
    }

    public static void setPropertyAccessResolver(PropertyAccessResolver resolver) {
        propertyAccessResolver = Objects.requireNonNull(resolver);
    }

    public static boolean isOwlClassEntity(Class<?> cls) {
        return cls != null && cls.getDeclaredAnnotation(OWLClass.class) != null;
    }

    public static String getOwlClass(Class<?> cls) {
        Objects.requireNonNull(cls);
        OWLClass owlClass = cls.getDeclaredAnnotation(OWLClass.class);
        if (owlClass == null) {
            throw new IllegalArgumentException(cls + " is not an OWL class entity.");
        }
        return BeanAnnotationProcessor.expandIriIfNecessary(owlClass.iri(), cls);
    }

    public static String expandIriIfNecessary(String iri, Class<?> declaringClass) {
        Objects.requireNonNull(declaringClass);
        return IdentifierUtil.isCompactIri(iri) ? BeanAnnotationProcessor.expandIri(iri, declaringClass).orElse(iri) : iri;
    }

    private static Optional<String> expandIri(String iri, Class<?> declaringClass) {
        assert (IdentifierUtil.isCompactIri(iri));
        int colonIndex = iri.indexOf(58);
        String prefix = iri.substring(0, colonIndex);
        String suffix = iri.substring(colonIndex + 1);
        Optional<String> ns = BeanAnnotationProcessor.resolveNamespace(declaringClass, prefix);
        if (ns.isPresent()) {
            return ns.map(v -> v + suffix);
        }
        if (declaringClass.getPackage() != null && (ns = BeanAnnotationProcessor.resolveNamespace(declaringClass.getPackage(), prefix)).isPresent()) {
            return ns.map(v -> v + suffix);
        }
        return declaringClass.getSuperclass() != null ? BeanAnnotationProcessor.expandIri(iri, declaringClass.getSuperclass()) : Optional.empty();
    }

    private static Optional<String> resolveNamespace(AnnotatedElement annotated, String prefix) {
        Optional<Namespace> namespace;
        Namespace ns = annotated.getDeclaredAnnotation(Namespace.class);
        if (ns != null && ns.prefix().equals(prefix)) {
            return Optional.of(ns.namespace());
        }
        Namespaces namespaces = annotated.getDeclaredAnnotation(Namespaces.class);
        if (namespaces != null && (namespace = Arrays.stream(namespaces.value()).filter(n -> n.prefix().equals(prefix)).findAny()).isPresent()) {
            return namespace.map(Namespace::namespace);
        }
        return Optional.empty();
    }

    public static Set<String> getOwlClasses(Object object) {
        Objects.requireNonNull(object);
        Class<?> cls = object.getClass();
        return BeanAnnotationProcessor.getOwlClasses(cls);
    }

    public static Set<String> getOwlClasses(Class<?> cls) {
        HashSet<String> classes = new HashSet<String>();
        BeanAnnotationProcessor.getAncestors(cls).forEach(c -> {
            OWLClass owlClass = c.getDeclaredAnnotation(OWLClass.class);
            if (owlClass != null) {
                classes.add(BeanAnnotationProcessor.expandIriIfNecessary(owlClass.iri(), c));
            }
        });
        return classes;
    }

    public static List<Class<?>> getAncestors(Class<?> cls) {
        ArrayList classes = new ArrayList();
        for (Class<?> current = cls; current != null && !current.equals(Object.class); current = current.getSuperclass()) {
            classes.add(current);
        }
        return classes;
    }

    public static List<Field> getSerializableFields(Object object) {
        Objects.requireNonNull(object);
        Class<?> cls = object.getClass();
        return BeanAnnotationProcessor.getMarshallableFields(cls, propertyAccessResolver::isReadable);
    }

    private static List<Field> getMarshallableFields(Class<?> cls, BiPredicate<Field, Class<?>> filter) {
        List<Class<?>> classes = BeanAnnotationProcessor.getAncestors(cls);
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c : classes) {
            for (Field f : c.getDeclaredFields()) {
                if (BeanAnnotationProcessor.isFieldTransient(f) || !filter.test(f, cls)) continue;
                fields.add(f);
            }
        }
        ArrayList<Field> result = new ArrayList<Field>(fields);
        result.sort(Comparator.comparing(BeanAnnotationProcessor::isObjectProperty));
        return result;
    }

    public static List<Field> getMarshallableFields(Class<?> cls) {
        Objects.requireNonNull(cls);
        return BeanAnnotationProcessor.getMarshallableFields(cls, ALWAYS_TRUE);
    }

    public static Map<String, Field> mapFieldsForDeserialization(Class<?> cls) {
        Objects.requireNonNull(cls);
        List<Field> fields = BeanAnnotationProcessor.getMarshallableFields(cls);
        return fields.stream().filter(f -> !BeanAnnotationProcessor.isPropertiesField(f)).collect(Collectors.toMap(BeanAnnotationProcessor::getAttributeIdentifier, Function.identity()));
    }

    private static boolean isFieldTransient(Field field) {
        return Modifier.isStatic(field.getModifiers()) || field.getDeclaredAnnotation(OWLAnnotationProperty.class) == null && field.getDeclaredAnnotation(OWLDataProperty.class) == null && field.getDeclaredAnnotation(OWLObjectProperty.class) == null && field.getDeclaredAnnotation(Id.class) == null && field.getDeclaredAnnotation(Types.class) == null && field.getDeclaredAnnotation(Properties.class) == null;
    }

    public static boolean isPropertiesField(Field field) {
        return field.getDeclaredAnnotation(Properties.class) != null;
    }

    public static boolean hasPropertiesField(Class<?> cls) {
        Objects.requireNonNull(cls);
        List<Field> fields = BeanAnnotationProcessor.getMarshallableFields(cls);
        Optional<Field> propertiesField = fields.stream().filter(BeanAnnotationProcessor::isPropertiesField).findAny();
        return propertiesField.isPresent();
    }

    public static Field getPropertiesField(Class<?> cls) {
        List<Field> fields = BeanAnnotationProcessor.getMarshallableFields(cls);
        Optional<Field> propsField = fields.stream().filter(BeanAnnotationProcessor::isPropertiesField).findAny();
        return propsField.orElseThrow(() -> new IllegalArgumentException(cls + " does not have a @Properties field."));
    }

    public static Optional<Field> getTypesField(Class<?> cls) {
        List<Field> fields = BeanAnnotationProcessor.getMarshallableFields(cls);
        return fields.stream().filter(BeanAnnotationProcessor::isTypesField).findFirst();
    }

    public static boolean hasTypesField(Class<?> cls) {
        return BeanAnnotationProcessor.getTypesField(cls).isPresent();
    }

    public static boolean isObjectProperty(Field field) {
        return field != null && field.getDeclaredAnnotation(OWLObjectProperty.class) != null;
    }

    public static boolean isAnnotationProperty(Field field) {
        return field != null && field.getDeclaredAnnotation(OWLAnnotationProperty.class) != null;
    }

    public static boolean isInstanceIdentifier(Field field) {
        return field != null && field.getDeclaredAnnotation(Id.class) != null;
    }

    public static boolean isTypesField(Field field) {
        return field != null && field.getDeclaredAnnotation(Types.class) != null;
    }

    public static boolean isWriteable(Field field) {
        return propertyAccessResolver.isWriteable(field);
    }

    public static String getAttributeIdentifier(Field field) {
        if (field.getDeclaredAnnotation(Id.class) != null) {
            return "@id";
        }
        OWLDataProperty dp = field.getDeclaredAnnotation(OWLDataProperty.class);
        if (dp != null) {
            return BeanAnnotationProcessor.expandIriIfNecessary(dp.iri(), field.getDeclaringClass());
        }
        OWLObjectProperty op = field.getDeclaredAnnotation(OWLObjectProperty.class);
        if (op != null) {
            return BeanAnnotationProcessor.expandIriIfNecessary(op.iri(), field.getDeclaringClass());
        }
        OWLAnnotationProperty ap = field.getDeclaredAnnotation(OWLAnnotationProperty.class);
        if (ap != null) {
            return BeanAnnotationProcessor.expandIriIfNecessary(ap.iri(), field.getDeclaringClass());
        }
        if (field.getDeclaredAnnotation(Types.class) != null) {
            return "@type";
        }
        throw new JsonLdSerializationException("Field " + field + " is not JSON-LD serializable.");
    }

    public static Optional<Field> getIdentifierField(Class<?> cls) {
        return BeanAnnotationProcessor.getMarshallableFields(cls, (f, c) -> f.isAnnotationPresent(Id.class)).stream().findFirst();
    }

    public static Optional<Object> getInstanceIdentifier(Object instance) {
        Objects.requireNonNull(instance);
        List<Class<?>> classes = BeanAnnotationProcessor.getAncestors(instance.getClass());
        for (Class<?> cls : classes) {
            for (Field f : cls.getDeclaredFields()) {
                if (f.getDeclaredAnnotation(Id.class) == null) continue;
                if (!f.canAccess(instance)) {
                    f.setAccessible(true);
                }
                try {
                    return Optional.ofNullable(f.get(instance));
                }
                catch (IllegalAccessException e) {
                    throw new JsonLdSerializationException("Unable to extract identifier of instance " + instance);
                }
            }
        }
        return Optional.empty();
    }

    public static String[] getAttributeOrder(Class<?> cls) {
        Objects.requireNonNull(cls);
        JsonLdAttributeOrder order = cls.getDeclaredAnnotation(JsonLdAttributeOrder.class);
        return order != null ? order.value() : EMPTY_ARRAY;
    }
}

