/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.common;

import cz.cvut.kbss.jopa.model.PersistenceProperties;
import cz.cvut.kbss.jsonld.common.CollectionType;
import cz.cvut.kbss.jsonld.exception.BeanProcessingException;
import cz.cvut.kbss.jsonld.exception.TargetTypeException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BeanClassProcessor {
    private BeanClassProcessor() {
        throw new AssertionError();
    }

    public static Object getFieldValue(Field field, Object instance) {
        Objects.requireNonNull(field);
        if (!field.canAccess(instance)) {
            field.setAccessible(true);
        }
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new BeanProcessingException("Unable to extract value of field " + field, e);
        }
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        Objects.requireNonNull(field);
        if (!field.canAccess(instance)) {
            field.setAccessible(true);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new BeanProcessingException("Unable to set value of field " + field, e);
        }
    }

    public static <T> T createInstance(Class<T> cls) {
        try {
            return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BeanProcessingException("Class " + cls + " is missing a public no-arg constructor.", e);
        }
    }

    public static Collection<?> createCollection(CollectionType type) {
        switch (type) {
            case LIST: {
                return new ArrayList();
            }
            case SET: {
                return new HashSet();
            }
        }
        throw new IllegalArgumentException("Unsupported collection type " + type);
    }

    public static Collection<?> createCollection(Field field) {
        Objects.requireNonNull(field);
        return BeanClassProcessor.createCollection(field.getType());
    }

    public static Collection<?> createCollection(Class<?> collectionType) {
        CollectionType type;
        Objects.requireNonNull(collectionType);
        if (Set.class.isAssignableFrom(collectionType)) {
            type = CollectionType.SET;
        } else if (List.class.isAssignableFrom(collectionType)) {
            type = CollectionType.LIST;
        } else {
            throw new IllegalArgumentException(collectionType + " is not a supported collection type.");
        }
        return BeanClassProcessor.createCollection(type);
    }

    public static Class<?> getCollectionItemType(Field field) {
        Objects.requireNonNull(field);
        return BeanClassProcessor.getGenericType(field, 0);
    }

    private static Class<?> getGenericType(Field field, int paramIndex) {
        try {
            ParameterizedType fieldType = (ParameterizedType)field.getGenericType();
            Type typeArgument = fieldType.getActualTypeArguments()[paramIndex];
            if (typeArgument instanceof Class) {
                return (Class)typeArgument;
            }
            return (Class)((ParameterizedType)typeArgument).getRawType();
        }
        catch (ClassCastException e) {
            throw new BeanProcessingException("Field " + field + " is not of parametrized type.");
        }
    }

    public static Class<?> getMapKeyType(Field field) {
        return BeanClassProcessor.getGenericType(field, 0);
    }

    public static Class<?> getMapValueType(Field field) {
        Objects.requireNonNull(field);
        try {
            return BeanClassProcessor.getGenericType(field, 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BeanProcessingException("Unable to determine declared Map value type of field " + field + ".", e);
        }
    }

    public static Class<?> getMapGenericValueType(Field field) {
        try {
            ParameterizedType fieldType = (ParameterizedType)field.getGenericType();
            Type typeArgument = fieldType.getActualTypeArguments()[1];
            if (typeArgument instanceof Class) {
                if (Collection.class.isAssignableFrom((Class)typeArgument)) {
                    return null;
                }
                throw new BeanProcessingException("Expected map value type to be generic. Field: " + field);
            }
            ParameterizedType valueType = (ParameterizedType)typeArgument;
            Type actualType = valueType.getActualTypeArguments()[0];
            if (Class.class.isAssignableFrom(actualType.getClass())) {
                return (Class)actualType;
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new BeanProcessingException("Field " + field + " is not of parametrized type.");
        }
    }

    public static boolean isCollection(Field field) {
        Objects.requireNonNull(field);
        return Collection.class.isAssignableFrom(field.getType());
    }

    public static void verifyPropertiesFieldType(Field field) {
        if (!Map.class.isAssignableFrom(field.getType())) {
            throw new TargetTypeException("@Properties field " + field + " must be a java.util.Map.");
        }
    }

    public static boolean isIndividualType(Class<?> cls) {
        return BeanClassProcessor.isIdentifierType(cls) || cls.isEnum();
    }

    public static boolean isIdentifierType(Class<?> cls) {
        return cls != null && PersistenceProperties.IDENTIFIER_TYPES.contains(cls);
    }
}

