/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.common;

import cz.cvut.kbss.jopa.model.annotations.Individual;
import cz.cvut.kbss.jsonld.exception.InvalidEnumMappingException;
import cz.cvut.kbss.jsonld.exception.JsonLdException;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EnumUtil.class);

    public static String resolveMappedIndividual(Enum<?> value) {
        return EnumUtil.findMatchingConstant(value.getDeclaringClass(), (e, iri) -> e == value, (e, iri) -> iri).orElseThrow(() -> new InvalidEnumMappingException("Missing individual mapping for enum constant " + value));
    }

    public static <T, E extends Enum<?>> Optional<T> findMatchingConstant(Class<E> enumType, BiPredicate<E, String> filter, BiFunction<E, String, T> mapper) {
        try {
            for (Field f : enumType.getDeclaredFields()) {
                if (!f.isEnumConstant()) continue;
                Individual individual = f.getAnnotation(Individual.class);
                Enum constant = (Enum)f.get(null);
                if (individual == null) {
                    LOG.warn("Enum constant {} is missing individual mapping, yet it can be used as object property value.", (Object)constant);
                    continue;
                }
                if (!filter.test(constant, individual.iri())) continue;
                return Optional.of(mapper.apply(constant, individual.iri()));
            }
        }
        catch (IllegalAccessException e) {
            throw new JsonLdException("Unable to access enum constant!", e);
        }
        return Optional.empty();
    }
}

