/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jopa.datatype.exception.DatatypeMappingException;
import cz.cvut.kbss.jsonld.deserialization.InstanceContext;
import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import java.util.Collection;
import java.util.Map;

class CollectionInstanceContext<T extends Collection>
extends InstanceContext<T> {
    private final Class<?> targetType;

    CollectionInstanceContext(T instance, Map<String, Object> knownInstances) {
        super(instance, knownInstances);
        this.targetType = null;
    }

    CollectionInstanceContext(T instance, Class<?> targetType, Map<String, Object> knownInstances) {
        super(instance, knownInstances);
        this.targetType = targetType;
    }

    @Override
    void addItem(Object item) {
        if (this.targetType == null) {
            ((Collection)this.instance).add(item);
            return;
        }
        try {
            Object toAdd = this.resolveAssignableValue(this.targetType, item);
            ((Collection)this.instance).add(toAdd);
        }
        catch (DatatypeMappingException e) {
            throw new JsonLdDeserializationException("Type mismatch when adding item " + item + " to collection.", e);
        }
    }

    @Override
    Class<?> getItemType() {
        return this.targetType;
    }
}

