/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.deserialization.DeserializationContext;
import cz.cvut.kbss.jsonld.deserialization.ValueDeserializer;
import cz.cvut.kbss.jsonld.deserialization.ValueDeserializers;
import cz.cvut.kbss.jsonld.deserialization.datetime.DateDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.DurationDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.InstantDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.LocalDateDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.LocalDateTimeDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.LocalTimeDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.OffsetDateTimeDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.OffsetTimeDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.PeriodDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.ZonedDateTimeDeserializer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CommonValueDeserializers
implements ValueDeserializers {
    private final Map<Class<?>, ValueDeserializer<?>> deserializers = new HashMap();

    public CommonValueDeserializers() {
        this.initBuiltInDeserializers();
    }

    private void initBuiltInDeserializers() {
        OffsetDateTimeDeserializer coreDatetimeDeserializer = new OffsetDateTimeDeserializer();
        OffsetTimeDeserializer coreTimeDeserializer = new OffsetTimeDeserializer();
        this.deserializers.put(OffsetDateTime.class, coreDatetimeDeserializer);
        this.deserializers.put(LocalDateTime.class, new LocalDateTimeDeserializer(coreDatetimeDeserializer));
        this.deserializers.put(ZonedDateTime.class, new ZonedDateTimeDeserializer(coreDatetimeDeserializer));
        this.deserializers.put(Date.class, new DateDeserializer(coreDatetimeDeserializer));
        this.deserializers.put(Instant.class, new InstantDeserializer(coreDatetimeDeserializer));
        this.deserializers.put(OffsetTime.class, coreTimeDeserializer);
        this.deserializers.put(LocalTime.class, new LocalTimeDeserializer(coreTimeDeserializer));
        this.deserializers.put(LocalDate.class, new LocalDateDeserializer());
        this.deserializers.put(Duration.class, new DurationDeserializer());
        this.deserializers.put(Period.class, new PeriodDeserializer());
    }

    @Override
    public <T> boolean hasCustomDeserializer(Class<T> type) {
        return this.deserializers.containsKey(type);
    }

    @Override
    public <T> Optional<ValueDeserializer<T>> getDeserializer(DeserializationContext<T> ctx) {
        Objects.requireNonNull(ctx);
        return Optional.ofNullable(this.deserializers.get(ctx.getTargetType()));
    }

    @Override
    public <T> void registerDeserializer(Class<T> forType, ValueDeserializer<T> deserializer) {
        Objects.requireNonNull(forType);
        Objects.requireNonNull(deserializer);
        this.deserializers.put(forType, deserializer);
    }

    @Override
    public void configure(Configuration configuration) {
        this.deserializers.values().forEach(dsr -> dsr.configure(configuration));
    }
}

