/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.common.CollectionType;
import cz.cvut.kbss.jsonld.deserialization.CollectionInstanceContext;
import cz.cvut.kbss.jsonld.deserialization.DummyCollectionInstanceContext;
import cz.cvut.kbss.jsonld.deserialization.InstanceBuilder;
import cz.cvut.kbss.jsonld.deserialization.InstanceContext;
import cz.cvut.kbss.jsonld.deserialization.MultilingualStringCollectionContext;
import cz.cvut.kbss.jsonld.deserialization.MultilingualStringContext;
import cz.cvut.kbss.jsonld.deserialization.NodeReferenceContext;
import cz.cvut.kbss.jsonld.deserialization.PropertiesInstanceContext;
import cz.cvut.kbss.jsonld.deserialization.SingularObjectContext;
import cz.cvut.kbss.jsonld.deserialization.TypesContext;
import cz.cvut.kbss.jsonld.deserialization.reference.PendingReferenceRegistry;
import cz.cvut.kbss.jsonld.deserialization.util.DataTypeTransformer;
import cz.cvut.kbss.jsonld.deserialization.util.TargetClassResolver;
import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import cz.cvut.kbss.jsonld.exception.TargetTypeException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public class DefaultInstanceBuilder
implements InstanceBuilder {
    private final Map<String, Object> knownInstances = new HashMap<String, Object>();
    private final Stack<InstanceContext> openInstances = new Stack();
    private final TargetClassResolver classResolver;
    private final PendingReferenceRegistry pendingReferenceRegistry;
    private InstanceContext currentInstance;

    public DefaultInstanceBuilder(TargetClassResolver classResolver, PendingReferenceRegistry pendingReferenceRegistry) {
        this.classResolver = classResolver;
        this.pendingReferenceRegistry = pendingReferenceRegistry;
    }

    @Override
    public void openObject(String id, String property, List<String> types) {
        InstanceContext<?> ctx;
        Objects.requireNonNull(property);
        Field targetField = this.currentInstance.getFieldForProperty(property);
        assert (targetField != null);
        Class<?> type = targetField.getType();
        if (BeanClassProcessor.isIdentifierType(type)) {
            ctx = new NodeReferenceContext(this.currentInstance, targetField, this.knownInstances);
            ctx.setIdentifierValue(id);
        } else {
            Object oldPropertyObject;
            ctx = this.openObjectForProperty(id, types, targetField);
            Object newPropertyObject = ctx.getInstance();
            if (!this.isPlural(property) && (oldPropertyObject = BeanClassProcessor.getFieldValue(targetField, this.currentInstance.getInstance())) != null && !oldPropertyObject.equals(newPropertyObject)) {
                throw JsonLdDeserializationException.singularAttributeCardinalityViolated(property, targetField);
            }
            this.currentInstance.setFieldValue(targetField, newPropertyObject);
        }
        this.openInstances.push(this.currentInstance);
        this.currentInstance = ctx;
    }

    private InstanceContext<?> openObjectForProperty(String id, List<String> types, Field targetField) {
        Class<?> type = targetField.getType();
        Class<?> targetClass = this.classResolver.getTargetClass(type, types);
        assert (BeanAnnotationProcessor.isOwlClassEntity(targetClass));
        if (this.knownInstances.containsKey(id)) {
            return this.reopenExistingInstance(id, targetClass);
        }
        Object instance = BeanClassProcessor.createInstance(targetClass);
        SingularObjectContext ctx = new SingularObjectContext(instance, BeanAnnotationProcessor.mapFieldsForDeserialization(targetClass), this.knownInstances);
        ctx.setIdentifierValue(id);
        return ctx;
    }

    private <T> InstanceContext<T> reopenExistingInstance(String id, Class<T> cls) {
        Object instance = this.knownInstances.get(id);
        if (!cls.isAssignableFrom(instance.getClass())) {
            throw new TargetTypeException("An instance with id " + id + " already exists, but its type " + instance.getClass() + " is not compatible with target type " + cls + ".");
        }
        return new SingularObjectContext<T>(cls.cast(instance), BeanAnnotationProcessor.mapFieldsForDeserialization(cls), this.knownInstances);
    }

    @Override
    public <T> void openObject(String id, Class<T> cls) {
        if (BeanClassProcessor.isIdentifierType(cls)) {
            NodeReferenceContext context = new NodeReferenceContext(this.currentInstance, this.knownInstances);
            ((InstanceContext)context).setIdentifierValue(id);
            assert (this.currentInstance != null);
            this.openInstances.push(this.currentInstance);
            this.currentInstance = context;
        } else if (this.knownInstances.containsKey(id)) {
            InstanceContext<T> context = this.reopenExistingInstance(id, cls);
            this.replaceCurrentContext(context);
        } else {
            T instance = BeanClassProcessor.createInstance(cls);
            SingularObjectContext<T> context = new SingularObjectContext<T>(instance, BeanAnnotationProcessor.mapFieldsForDeserialization(cls), this.knownInstances);
            this.replaceCurrentContext(context);
            this.currentInstance.setIdentifierValue(id);
        }
    }

    private void replaceCurrentContext(InstanceContext<?> ctx) {
        if (this.currentInstance != null) {
            this.openInstances.push(this.currentInstance);
        }
        this.currentInstance = ctx;
    }

    @Override
    public void closeObject() {
        this.currentInstance.close();
        if (this.currentInstance.getIdentifier() != null) {
            this.pendingReferenceRegistry.resolveReferences(this.currentInstance.getIdentifier(), this.currentInstance.getInstance());
        }
        if (!this.openInstances.isEmpty()) {
            InstanceContext closing = this.currentInstance;
            this.currentInstance = this.openInstances.pop();
            this.currentInstance.addItem(closing.getInstance());
        }
    }

    @Override
    public void openCollection(String property) {
        InstanceContext ctx;
        Objects.requireNonNull(property);
        Field targetField = this.currentInstance.getFieldForProperty(property);
        if (targetField == null) {
            ctx = this.currentInstance.hasPropertiesField() && !"@type".equals(property) ? this.buildPropertiesContext(property) : new DummyCollectionInstanceContext(this.knownInstances);
        } else {
            if (MultilingualString.class.equals(targetField.getType())) {
                ctx = new MultilingualStringContext(new MultilingualString(), this.knownInstances);
            } else {
                Class<?> elementType;
                this.verifyPluralAttribute(property, targetField);
                Collection instance = (Collection)this.getCollectionForField(targetField);
                ctx = "@type".equals(property) ? new TypesContext(instance, this.knownInstances, BeanClassProcessor.getCollectionItemType(targetField), this.currentInstance.getInstanceType()) : (MultilingualString.class.equals(elementType = BeanClassProcessor.getCollectionItemType(targetField)) ? new MultilingualStringCollectionContext<Collection>(instance, this.knownInstances) : new CollectionInstanceContext<Collection>(instance, BeanClassProcessor.getCollectionItemType(targetField), this.knownInstances));
            }
            this.currentInstance.setFieldValue(targetField, ctx.instance);
        }
        this.openInstances.push(this.currentInstance);
        this.currentInstance = ctx;
    }

    private InstanceContext<?> buildPropertiesContext(String property) {
        Field propsField = BeanAnnotationProcessor.getPropertiesField(this.currentInstance.getInstanceType());
        BeanClassProcessor.verifyPropertiesFieldType(propsField);
        Map propertiesMap = (Map)this.getCollectionForField(propsField);
        this.currentInstance.setFieldValue(propsField, propertiesMap);
        return new PropertiesInstanceContext(propertiesMap, property, propsField);
    }

    private void verifyPluralAttribute(String property, Field field) {
        if (!this.isPlural(property)) {
            throw JsonLdDeserializationException.singularAttributeCardinalityViolated(property, field);
        }
    }

    private Object getCollectionForField(Field targetField) {
        Object existing = BeanClassProcessor.getFieldValue(targetField, this.currentInstance.getInstance());
        if (existing != null) {
            return existing;
        }
        return BeanAnnotationProcessor.isPropertiesField(targetField) ? new HashMap() : BeanClassProcessor.createCollection(targetField);
    }

    @Override
    public void openCollection(CollectionType collectionType) {
        Collection<?> collection = BeanClassProcessor.createCollection(collectionType);
        CollectionInstanceContext context = new CollectionInstanceContext(collection, this.knownInstances);
        this.replaceCurrentContext(context);
    }

    @Override
    public void closeCollection() {
        if (!this.openInstances.isEmpty()) {
            this.currentInstance = this.openInstances.pop();
        }
    }

    @Override
    public void addValue(String property, Object value) {
        assert (this.currentInstance != null);
        Field targetField = this.currentInstance.getFieldForProperty(property);
        assert (targetField != null);
        if (BeanClassProcessor.isCollection(targetField)) {
            this.openCollection(property);
            this.addValue(value);
            this.closeCollection();
        } else {
            this.currentInstance.setFieldValue(targetField, value);
        }
    }

    @Override
    public void addValue(Object value) {
        assert (this.currentInstance != null);
        this.currentInstance.addItem(value);
    }

    @Override
    public void addNodeReference(String property, String nodeId) {
        Field field = this.currentInstance.getFieldForProperty(property);
        assert (field != null);
        Class<?> type = field.getType();
        if (this.canDirectlyAddNodeReference(type)) {
            this.currentInstance.setFieldValue(field, DataTypeTransformer.transformValue(URI.create(nodeId), type));
        } else if (this.knownInstances.containsKey(nodeId)) {
            this.currentInstance.setFieldValue(field, this.knownInstances.get(nodeId));
        } else {
            this.pendingReferenceRegistry.addPendingReference(nodeId, this.currentInstance.getInstance(), field);
        }
    }

    @Override
    public void addNodeReference(String nodeId) {
        Class<?> targetType = this.getCurrentCollectionElementType();
        if (this.canDirectlyAddNodeReference(targetType)) {
            this.currentInstance.addItem(DataTypeTransformer.transformValue(URI.create(nodeId), targetType));
        } else if (this.knownInstances.containsKey(nodeId)) {
            this.currentInstance.addItem(this.knownInstances.get(nodeId));
        } else {
            this.pendingReferenceRegistry.addPendingReference(nodeId, (Collection)this.currentInstance.getInstance());
        }
    }

    private boolean canDirectlyAddNodeReference(Class<?> targetType) {
        return BeanClassProcessor.isIdentifierType(targetType) || Objects.equals(Object.class, targetType) || targetType == null;
    }

    @Override
    public Object getCurrentRoot() {
        return this.currentInstance != null ? this.currentInstance.getInstance() : null;
    }

    @Override
    public Class<?> getCurrentCollectionElementType() {
        try {
            return this.currentInstance.getItemType();
        }
        catch (UnsupportedOperationException e) {
            throw new JsonLdDeserializationException("The current instance is not a collection.", e);
        }
    }

    @Override
    public boolean isPlural(String property) {
        assert (this.isPropertyMapped(property));
        Field mappedField = this.currentInstance.getFieldForProperty(property);
        return mappedField == null || BeanClassProcessor.isCollection(mappedField);
    }

    @Override
    public boolean isPropertyMapped(String property) {
        return this.currentInstance.isPropertyMapped(property) || "@type".equals(property);
    }

    @Override
    public boolean isPropertyDeserializable(String property) {
        return this.currentInstance.supports(property) || "@type".equals(property);
    }

    @Override
    public Class<?> getCurrentContextType() {
        return this.currentInstance.getInstanceType();
    }

    @Override
    public boolean isCurrentCollectionProperties() {
        return this.currentInstance instanceof PropertiesInstanceContext;
    }

    @Override
    public Class<?> getTargetType(String property) {
        assert (this.isPropertyMapped(property));
        Field field = this.currentInstance.getFieldForProperty(property);
        if (field == null && this.currentInstance.hasPropertiesField()) {
            return Object.class;
        }
        assert (field != null);
        return BeanClassProcessor.isCollection(field) ? BeanClassProcessor.getCollectionItemType(field) : field.getType();
    }
}

