/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.deserialization.util.DataTypeTransformer;
import cz.cvut.kbss.jsonld.exception.UnknownPropertyException;
import java.lang.reflect.Field;
import java.util.Map;

abstract class InstanceContext<T> {
    private static final String BLANK_NODE_ID_START = "_:";
    T instance;
    private String identifier;
    final Map<String, Object> knownInstances;

    InstanceContext(T instance, Map<String, Object> knownInstances) {
        this.instance = instance;
        this.knownInstances = knownInstances;
    }

    T getInstance() {
        return this.instance;
    }

    Class<T> getInstanceType() {
        return this.instance.getClass();
    }

    void setIdentifierValue(String value) {
        Field idField = this.getFieldForProperty("@id");
        boolean blankNode = InstanceContext.isBlankNodeIdentifier(value);
        if (idField == null) {
            if (blankNode) {
                return;
            }
            throw UnknownPropertyException.create("@id", this.getInstanceType());
        }
        if (blankNode && !idField.getType().equals(String.class)) {
            return;
        }
        this.setFieldValue(idField, value);
        this.identifier = value;
        this.knownInstances.put(value, this.instance);
    }

    private static boolean isBlankNodeIdentifier(String identifier) {
        return identifier.startsWith(BLANK_NODE_ID_START);
    }

    String getIdentifier() {
        return this.identifier;
    }

    Field getFieldForProperty(String property) {
        throw new UnsupportedOperationException("Not supported by this type of instance context.");
    }

    void setFieldValue(Field field, Object value) {
    }

    void addItem(Object item) {
    }

    Class<?> getItemType() {
        throw new UnsupportedOperationException("Not supported by this type of instance context.");
    }

    Object resolveAssignableValue(Class<?> targetType, Object value) {
        if (value != null && !targetType.isAssignableFrom(value.getClass())) {
            if (this.knownInstances.containsKey(value.toString())) {
                Object known = this.knownInstances.get(value.toString());
                if (!targetType.isAssignableFrom(known.getClass())) {
                    return DataTypeTransformer.transformValue(value, targetType);
                }
                return known;
            }
            return DataTypeTransformer.transformValue(value, targetType);
        }
        return value;
    }

    boolean isPropertyMapped(String property) {
        return false;
    }

    boolean supports(String property) {
        return false;
    }

    boolean hasPropertiesField() {
        return BeanAnnotationProcessor.hasPropertiesField(this.getInstanceType());
    }

    void close() {
    }
}

