/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jopa.model.annotations.OWLClass;
import cz.cvut.kbss.jsonld.ConfigParam;
import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.common.Configured;
import cz.cvut.kbss.jsonld.deserialization.CommonValueDeserializers;
import cz.cvut.kbss.jsonld.deserialization.ValueDeserializer;
import cz.cvut.kbss.jsonld.deserialization.ValueDeserializers;
import cz.cvut.kbss.jsonld.deserialization.expanded.ExpandedJsonLdDeserializer;
import cz.cvut.kbss.jsonld.deserialization.util.ClasspathScanner;
import cz.cvut.kbss.jsonld.deserialization.util.TargetClassResolver;
import cz.cvut.kbss.jsonld.deserialization.util.TargetClassResolverConfig;
import cz.cvut.kbss.jsonld.deserialization.util.TypeMap;
import jakarta.json.JsonValue;
import java.util.Objects;

public abstract class JsonLdDeserializer
implements Configured {
    private final Configuration configuration;
    protected final TargetClassResolver classResolver;
    protected ValueDeserializers deserializers = new CommonValueDeserializers();

    protected JsonLdDeserializer() {
        this.configuration = new Configuration();
        this.classResolver = this.initializeTargetClassResolver();
    }

    protected JsonLdDeserializer(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.classResolver = this.initializeTargetClassResolver();
    }

    private TargetClassResolver initializeTargetClassResolver() {
        TypeMap typeMap = new TypeMap();
        String scanPath = this.configuration.get(ConfigParam.SCAN_PACKAGE, "");
        new ClasspathScanner(c -> {
            OWLClass ann = c.getDeclaredAnnotation(OWLClass.class);
            if (ann != null) {
                typeMap.register(BeanAnnotationProcessor.expandIriIfNecessary(ann.iri(), c), (Class<?>)c);
            }
        }).processClasses(scanPath);
        return new TargetClassResolver(typeMap, new TargetClassResolverConfig(this.configuration.is(ConfigParam.ASSUME_TARGET_TYPE), this.configuration().is(ConfigParam.ENABLE_OPTIMISTIC_TARGET_TYPE_RESOLUTION), this.configuration().is(ConfigParam.PREFER_SUPERCLASS)));
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    public <T> void registerDeserializer(Class<T> type, ValueDeserializer<T> deserializer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(deserializer);
        this.deserializers.registerDeserializer(type, deserializer);
    }

    public abstract <T> T deserialize(JsonValue var1, Class<T> var2);

    public static JsonLdDeserializer createExpandedDeserializer(Configuration configuration) {
        return new ExpandedJsonLdDeserializer(configuration);
    }

    public static JsonLdDeserializer createExpandedDeserializer() {
        return new ExpandedJsonLdDeserializer();
    }
}

