/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jsonld.deserialization.InstanceContext;
import cz.cvut.kbss.jsonld.deserialization.util.LangString;
import java.util.Collection;
import java.util.Map;

class MultilingualStringCollectionContext<T extends Collection<MultilingualString>>
extends InstanceContext<T> {
    MultilingualStringCollectionContext(T instance, Map<String, Object> knownInstances) {
        super(instance, knownInstances);
    }

    @Override
    void addItem(Object item) {
        assert (item != null);
        if (item instanceof LangString) {
            LangString value = (LangString)((Object)item);
            String language = value.getLanguage().orElse(null);
            MultilingualString element = this.getFirstAvailable(language);
            element.set(language, value.getValue());
        } else {
            MultilingualString element = this.getFirstAvailable(null);
            element.set(item.toString());
        }
    }

    private MultilingualString getFirstAvailable(String language) {
        return ((Collection)this.instance).stream().filter(ms -> !ms.contains(language)).findFirst().orElseGet(() -> {
            MultilingualString newOne = new MultilingualString();
            ((Collection)this.instance).add(newOne);
            return newOne;
        });
    }

    @Override
    Class<?> getItemType() {
        return MultilingualString.class;
    }
}

