/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jsonld.deserialization.InstanceContext;
import cz.cvut.kbss.jsonld.deserialization.util.DataTypeTransformer;
import java.lang.reflect.Field;
import java.util.Map;

class NodeReferenceContext<T>
extends InstanceContext<T> {
    private final InstanceContext<?> owner;
    private final Field targetField;

    NodeReferenceContext(InstanceContext<?> owner, Field targetField, Map<String, Object> knownInstances) {
        super(null, knownInstances);
        this.owner = owner;
        this.targetField = targetField;
    }

    NodeReferenceContext(InstanceContext<?> owner, Map<String, Object> knownInstances) {
        super(null, knownInstances);
        this.owner = owner;
        this.targetField = null;
    }

    @Override
    void setIdentifierValue(String value) {
        Class<?> targetType = this.targetField != null ? this.targetField.getType() : this.owner.getItemType();
        this.instance = this.transformToTargetType(value, targetType);
    }

    private Object transformToTargetType(String id, Class<?> targetType) {
        return DataTypeTransformer.transformValue(id, targetType);
    }

    @Override
    void close() {
        assert (this.instance != null);
        if (this.targetField != null) {
            this.owner.setFieldValue(this.targetField, this.instance);
        } else {
            this.owner.addItem(this.instance);
        }
    }

    @Override
    boolean isPropertyMapped(String property) {
        return property.equals("@id");
    }

    @Override
    boolean supports(String property) {
        return this.isPropertyMapped(property);
    }

    @Override
    Class<T> getInstanceType() {
        return null;
    }

    @Override
    Field getFieldForProperty(String property) {
        return null;
    }

    @Override
    boolean hasPropertiesField() {
        return false;
    }
}

