/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.deserialization.InstanceContext;
import cz.cvut.kbss.jsonld.deserialization.util.DataTypeTransformer;
import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class PropertiesInstanceContext
extends InstanceContext<Map> {
    private final Field propertiesField;
    private final String property;

    PropertiesInstanceContext(Map<?, ?> instance, String property, Field propertiesField) {
        super(instance, Collections.emptyMap());
        this.property = property;
        this.propertiesField = propertiesField;
    }

    @Override
    void addItem(Object item) {
        Class<?> keyType = BeanClassProcessor.getMapKeyType(this.propertiesField);
        Object typedProperty = DataTypeTransformer.transformValue(this.property, keyType);
        Class<?> valueType = BeanClassProcessor.getMapValueType(this.propertiesField);
        if (Collection.class.isAssignableFrom(valueType)) {
            Collection values;
            if (((Map)this.instance).containsKey(typedProperty)) {
                values = (Collection)((Map)this.instance).get(typedProperty);
            } else {
                values = BeanClassProcessor.createCollection(valueType);
                ((Map)this.instance).put(typedProperty, values);
            }
            Class<?> itemType = BeanClassProcessor.getMapGenericValueType(this.propertiesField);
            Object itemValue = itemType != null ? DataTypeTransformer.transformValue(item, itemType) : item;
            values.add(itemValue);
        } else {
            if (((Map)this.instance).containsKey(typedProperty)) {
                throw JsonLdDeserializationException.singularAttributeCardinalityViolated(this.property, this.propertiesField);
            }
            Object typedValue = DataTypeTransformer.transformValue(item, valueType);
            ((Map)this.instance).put(typedProperty, typedValue);
        }
    }

    @Override
    Class<?> getItemType() {
        Class<?> mapValueType = BeanClassProcessor.getMapValueType(this.propertiesField);
        return Collection.class.isAssignableFrom(mapValueType) ? BeanClassProcessor.getMapGenericValueType(this.propertiesField) : mapValueType;
    }
}

