/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jopa.datatype.exception.DatatypeMappingException;
import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.deserialization.InstanceContext;
import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

class SingularObjectContext<T>
extends InstanceContext<T> {
    private final Map<String, Field> fieldMap;

    SingularObjectContext(T instance, Map<String, Field> fieldMap, Map<String, Object> knownInstances) {
        super(instance, knownInstances);
        this.fieldMap = fieldMap;
    }

    @Override
    Field getFieldForProperty(String property) {
        return this.fieldMap.get(property);
    }

    @Override
    void setFieldValue(Field field, Object value) {
        assert (!(this.instance instanceof Collection));
        try {
            Object toSet = this.resolveAssignableValue(field.getType(), value);
            BeanClassProcessor.setFieldValue(field, this.instance, toSet);
        }
        catch (DatatypeMappingException e) {
            throw new JsonLdDeserializationException("Type mismatch when setting value " + value + " on field " + field + ".", e);
        }
    }

    @Override
    boolean isPropertyMapped(String property) {
        return this.fieldMap.containsKey(property) || this.hasPropertiesField();
    }

    @Override
    boolean supports(String property) {
        if (!this.isPropertyMapped(property)) {
            return false;
        }
        return !this.fieldMap.containsKey(property) || BeanAnnotationProcessor.isWriteable(this.fieldMap.get(property));
    }
}

