/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization;

import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.deserialization.InstanceContext;
import cz.cvut.kbss.jsonld.deserialization.util.DataTypeTransformer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class TypesContext<T extends Collection<E>, E>
extends InstanceContext<T> {
    private final Set<String> mappedTypes;
    private final Class<E> elementType;

    TypesContext(T instance, Map<String, Object> knownInstances, Class<E> elementType, Class<?> ownerType) {
        super(instance, knownInstances);
        this.elementType = elementType;
        this.mappedTypes = BeanAnnotationProcessor.getOwlClasses(ownerType);
    }

    @Override
    void addItem(Object item) {
        assert (item instanceof String);
        if (this.mappedTypes.contains(item)) {
            return;
        }
        if (!this.elementType.isAssignableFrom(item.getClass())) {
            ((Collection)this.instance).add(DataTypeTransformer.transformValue(item, this.elementType));
        } else {
            ((Collection)this.instance).add(this.elementType.cast(item));
        }
    }

    @Override
    Class<?> getItemType() {
        return this.elementType;
    }
}

