/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.datetime;

import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.deserialization.DeserializationContext;
import cz.cvut.kbss.jsonld.deserialization.ValueDeserializer;
import cz.cvut.kbss.jsonld.deserialization.datetime.EpochBasedDateTimeResolver;
import cz.cvut.kbss.jsonld.deserialization.datetime.StringBasedDateTimeResolver;
import cz.cvut.kbss.jsonld.deserialization.util.ValueUtils;
import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.time.OffsetDateTime;

public class OffsetDateTimeDeserializer
implements ValueDeserializer<OffsetDateTime> {
    private final StringBasedDateTimeResolver stringResolver = new StringBasedDateTimeResolver();
    private final EpochBasedDateTimeResolver epochResolver = new EpochBasedDateTimeResolver();

    @Override
    public OffsetDateTime deserialize(JsonValue jsonNode, DeserializationContext<OffsetDateTime> ctx) {
        JsonValue value = ValueUtils.getValue(jsonNode);
        try {
            return value.getValueType() == JsonValue.ValueType.NUMBER ? this.epochResolver.resolve((JsonNumber)value) : this.stringResolver.resolve(ValueUtils.stringValue(value));
        }
        catch (RuntimeException e) {
            throw new JsonLdDeserializationException("Unable to deserialize datetime value.", e);
        }
    }

    @Override
    public void configure(Configuration config) {
        this.stringResolver.configure(config);
    }
}

