/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.expanded;

import cz.cvut.kbss.jsonld.deserialization.DeserializationContext;
import cz.cvut.kbss.jsonld.deserialization.InstanceBuilder;
import cz.cvut.kbss.jsonld.deserialization.expanded.Deserializer;
import cz.cvut.kbss.jsonld.deserialization.expanded.DeserializerConfig;
import cz.cvut.kbss.jsonld.deserialization.expanded.ObjectDeserializer;
import cz.cvut.kbss.jsonld.deserialization.util.DataTypeTransformer;
import cz.cvut.kbss.jsonld.deserialization.util.LangString;
import cz.cvut.kbss.jsonld.deserialization.util.ValueUtils;
import cz.cvut.kbss.jsonld.deserialization.util.XSDTypeCoercer;
import cz.cvut.kbss.jsonld.exception.MissingIdentifierException;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;

class CollectionDeserializer
extends Deserializer<JsonArray> {
    private final String property;

    CollectionDeserializer(InstanceBuilder instanceBuilder, DeserializerConfig config, String property) {
        super(instanceBuilder, config);
        this.property = property;
    }

    @Override
    void processValue(JsonArray value) {
        if (value.size() == 1 && ((JsonValue)value.get(0)).getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject obj = value.getJsonObject(0);
            if (!this.instanceBuilder.isPlural(this.property)) {
                this.resolvePropertyValue(obj);
                return;
            }
            if (obj.size() == 1 && obj.containsKey((Object)"@list")) {
                assert (((JsonValue)obj.get((Object)"@list")).getValueType() == JsonValue.ValueType.ARRAY);
                this.processValue(obj.getJsonArray("@list"));
                return;
            }
        }
        this.instanceBuilder.openCollection(this.property);
        for (JsonValue item : value) {
            if (item.getValueType() == JsonValue.ValueType.OBJECT) {
                this.resolveValue(item.asJsonObject());
                continue;
            }
            this.instanceBuilder.addValue(ValueUtils.literalValue(item));
        }
        this.instanceBuilder.closeCollection();
    }

    private void resolveValue(JsonObject value) {
        Class<?> targetType = this.instanceBuilder.getCurrentCollectionElementType();
        if (this.config.getDeserializers().hasCustomDeserializer(targetType)) {
            this.instanceBuilder.addValue(this.deserializeUsingCustomDeserializer(targetType, value));
        } else if (value.size() == 1 && value.containsKey((Object)"@value")) {
            this.instanceBuilder.addValue(ValueUtils.literalValue(ValueUtils.getValue((JsonValue)value)));
        } else if (value.size() == 1 && value.containsKey((Object)"@id")) {
            this.handleReferenceNodeInCollection(value, targetType);
        } else if (value.containsKey((Object)"@language")) {
            assert (value.containsKey((Object)"@value"));
            this.instanceBuilder.addValue((Object)new LangString(ValueUtils.stringValue(ValueUtils.getValue((JsonValue)value)), ValueUtils.stringValue((JsonValue)value.get((Object)"@language"))));
        } else if (this.instanceBuilder.isCurrentCollectionProperties()) {
            if (!value.containsKey((Object)"@id")) {
                throw new MissingIdentifierException("Cannot put an object without an identifier into @Properties. Object: " + value);
            }
            this.instanceBuilder.addValue(URI.create(ValueUtils.stringValue((JsonValue)value.get((Object)"@id"))));
        } else {
            Class<?> elementType = this.instanceBuilder.getCurrentCollectionElementType();
            new ObjectDeserializer(this.instanceBuilder, this.config, elementType).processValue(value);
        }
    }

    private void handleReferenceNodeInCollection(JsonObject value, Class<?> targetType) {
        assert (value.size() == 1 && value.containsKey((Object)"@id"));
        String identifier = ValueUtils.stringValue((JsonValue)value.get((Object)"@id"));
        if (targetType.isEnum()) {
            this.instanceBuilder.addValue(DataTypeTransformer.transformIndividualToEnumConstant(identifier, targetType));
        } else {
            this.instanceBuilder.addNodeReference(identifier);
        }
    }

    private void resolvePropertyValue(JsonObject value) {
        Class<?> targetType = this.instanceBuilder.getTargetType(this.property);
        if (this.config.getDeserializers().hasCustomDeserializer(targetType)) {
            this.instanceBuilder.addValue(this.property, this.deserializeUsingCustomDeserializer(targetType, value));
            return;
        }
        if (value.containsKey((Object)"@value")) {
            this.extractLiteralValue(value);
        } else if (value.size() == 1 && value.containsKey((Object)"@id")) {
            this.handleSingularReferenceNode(value, targetType);
        } else {
            new ObjectDeserializer(this.instanceBuilder, this.config, this.property).processValue(value);
        }
    }

    private <T> T deserializeUsingCustomDeserializer(Class<T> targetType, JsonObject value) {
        DeserializationContext<T> ctx = new DeserializationContext<T>(targetType, this.config.getTargetResolver());
        assert (this.config.getDeserializers().getDeserializer(ctx).isPresent());
        return this.config.getDeserializers().getDeserializer(ctx).get().deserialize((JsonValue)value, ctx);
    }

    private void extractLiteralValue(JsonObject value) {
        JsonValue val = (JsonValue)value.get((Object)"@value");
        if (value.containsKey((Object)"@type")) {
            this.instanceBuilder.addValue(this.property, XSDTypeCoercer.coerceType(ValueUtils.stringValue(val), ValueUtils.stringValue((JsonValue)value.get((Object)"@type"))));
        } else if (value.containsKey((Object)"@language")) {
            this.instanceBuilder.addValue(this.property, (Object)new LangString(ValueUtils.stringValue(val), ValueUtils.stringValue((JsonValue)value.get((Object)"@language"))));
        } else {
            this.instanceBuilder.addValue(this.property, ValueUtils.literalValue(val));
        }
    }

    private void handleSingularReferenceNode(JsonObject value, Class<?> targetType) {
        assert (value.size() == 1 && value.containsKey((Object)"@id"));
        String identifier = ValueUtils.stringValue((JsonValue)value.get((Object)"@id"));
        if (targetType.isEnum()) {
            this.instanceBuilder.addValue(this.property, DataTypeTransformer.transformIndividualToEnumConstant(identifier, targetType));
        } else {
            this.instanceBuilder.addNodeReference(this.property, identifier);
        }
    }
}

