/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.expanded;

import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.deserialization.InstanceBuilder;
import cz.cvut.kbss.jsonld.deserialization.expanded.DeserializerConfig;
import cz.cvut.kbss.jsonld.deserialization.util.ValueUtils;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

abstract class Deserializer<X> {
    final InstanceBuilder instanceBuilder;
    final DeserializerConfig config;

    Deserializer(InstanceBuilder instanceBuilder, DeserializerConfig config) {
        this.instanceBuilder = instanceBuilder;
        this.config = config;
    }

    Configuration configuration() {
        return this.config.getConfiguration();
    }

    <T> Class<? extends T> resolveTargetClass(JsonObject jsonRoot, Class<T> resultClass) {
        if (BeanClassProcessor.isIdentifierType(resultClass)) {
            return resultClass;
        }
        List<String> types = this.getObjectTypes(jsonRoot);
        return this.config.getTargetResolver().getTargetClass(resultClass, types);
    }

    List<String> getObjectTypes(JsonObject jsonLdObject) {
        JsonValue types = (JsonValue)jsonLdObject.get((Object)"@type");
        if (types == null) {
            return Collections.emptyList();
        }
        assert (types.getValueType() == JsonValue.ValueType.ARRAY);
        return types.asJsonArray().stream().map(ValueUtils::stringValue).collect(Collectors.toList());
    }

    abstract void processValue(X var1);
}

