/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.expanded;

import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.deserialization.DefaultInstanceBuilder;
import cz.cvut.kbss.jsonld.deserialization.DeserializationContext;
import cz.cvut.kbss.jsonld.deserialization.InstanceBuilder;
import cz.cvut.kbss.jsonld.deserialization.JsonLdDeserializer;
import cz.cvut.kbss.jsonld.deserialization.expanded.DeserializerConfig;
import cz.cvut.kbss.jsonld.deserialization.expanded.ObjectDeserializer;
import cz.cvut.kbss.jsonld.deserialization.reference.PendingReferenceRegistry;
import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;

public class ExpandedJsonLdDeserializer
extends JsonLdDeserializer {
    public ExpandedJsonLdDeserializer() {
    }

    public ExpandedJsonLdDeserializer(Configuration configuration) {
        super(configuration);
    }

    @Override
    public <T> T deserialize(JsonValue jsonLd, Class<T> resultClass) {
        if (jsonLd.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new JsonLdDeserializationException("Expanded JSON-LD deserializer requires a JSON-LD array as input.");
        }
        JsonArray input = jsonLd.asJsonArray();
        if (input.size() != 1) {
            throw new JsonLdDeserializationException("Input is not expanded JSON-LD. The input does not contain exactly one root element.");
        }
        this.deserializers.configure(this.configuration());
        JsonObject root = input.getJsonObject(0);
        PendingReferenceRegistry referenceRegistry = new PendingReferenceRegistry();
        if (this.deserializers.hasCustomDeserializer(resultClass)) {
            DeserializationContext<T> ctx = new DeserializationContext<T>(resultClass, this.classResolver);
            assert (this.deserializers.getDeserializer(ctx).isPresent());
            return this.deserializers.getDeserializer(ctx).get().deserialize((JsonValue)root, ctx);
        }
        DefaultInstanceBuilder instanceBuilder = new DefaultInstanceBuilder(this.classResolver, referenceRegistry);
        new ObjectDeserializer((InstanceBuilder)instanceBuilder, new DeserializerConfig(this.configuration(), this.classResolver, this.deserializers), resultClass).processValue(root);
        referenceRegistry.verifyNoUnresolvedReferencesExist();
        assert (resultClass.isAssignableFrom(instanceBuilder.getCurrentRoot().getClass()));
        return resultClass.cast(instanceBuilder.getCurrentRoot());
    }
}

