/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.expanded;

import cz.cvut.kbss.jsonld.ConfigParam;
import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.common.IdentifierUtil;
import cz.cvut.kbss.jsonld.deserialization.InstanceBuilder;
import cz.cvut.kbss.jsonld.deserialization.expanded.CollectionDeserializer;
import cz.cvut.kbss.jsonld.deserialization.expanded.Deserializer;
import cz.cvut.kbss.jsonld.deserialization.expanded.DeserializerConfig;
import cz.cvut.kbss.jsonld.deserialization.util.ValueUtils;
import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import cz.cvut.kbss.jsonld.exception.UnknownPropertyException;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

class ObjectDeserializer
extends Deserializer<JsonObject> {
    private final String property;
    private final Class<?> targetClass;

    ObjectDeserializer(InstanceBuilder instanceBuilder, DeserializerConfig config, String property) {
        super(instanceBuilder, config);
        assert (property != null);
        this.property = property;
        this.targetClass = null;
    }

    ObjectDeserializer(InstanceBuilder instanceBuilder, DeserializerConfig config, Class<?> targetClass) {
        super(instanceBuilder, config);
        assert (targetClass != null);
        this.targetClass = targetClass;
        this.property = null;
    }

    @Override
    void processValue(JsonObject value) {
        this.openObject(value);
        List<String> orderedProps = this.orderAttributesForProcessing(value);
        for (String property : orderedProps) {
            boolean shouldSkip = this.shouldSkipProperty(property);
            if (shouldSkip) continue;
            assert (((JsonValue)value.get((Object)property)).getValueType() == JsonValue.ValueType.ARRAY);
            new CollectionDeserializer(this.instanceBuilder, this.config, property).processValue(value.getJsonArray(property));
        }
        this.instanceBuilder.closeObject();
    }

    private void openObject(JsonObject value) {
        block6: {
            try {
                if (this.property != null) {
                    this.instanceBuilder.openObject(this.getId(value), this.property, this.getObjectTypes(value));
                } else {
                    assert (this.targetClass != null);
                    Class<?> cls = this.resolveTargetClass(value, this.targetClass);
                    assert (this.targetClass.isAssignableFrom(cls));
                    this.instanceBuilder.openObject(this.getId(value), cls);
                }
            }
            catch (UnknownPropertyException e) {
                if (this.configuration().is(ConfigParam.IGNORE_UNKNOWN_PROPERTIES)) break block6;
                throw e;
            }
        }
    }

    private String getId(JsonObject object) {
        return object.containsKey((Object)"@id") ? ValueUtils.stringValue((JsonValue)object.get((Object)"@id")) : IdentifierUtil.generateBlankNodeId();
    }

    private List<String> orderAttributesForProcessing(JsonObject value) {
        List<String> propertyOrder = this.getPropertyOrder();
        HashSet<String> ordered = new HashSet<String>(propertyOrder);
        ArrayList<String> result = new ArrayList<String>();
        propertyOrder.stream().filter(arg_0 -> value.containsKey(arg_0)).forEach(result::add);
        value.keySet().stream().filter(p -> !ordered.contains(p)).forEach(result::add);
        return result;
    }

    private List<String> getPropertyOrder() {
        Class<?> cls = this.instanceBuilder.getCurrentContextType();
        if (cls == null) {
            return Collections.emptyList();
        }
        String[] attributeOrder = BeanAnnotationProcessor.getAttributeOrder(cls);
        if (attributeOrder.length == 0) {
            return Collections.emptyList();
        }
        List<Field> fields = BeanAnnotationProcessor.getMarshallableFields(this.instanceBuilder.getCurrentContextType());
        ArrayList<String> propertyOrder = new ArrayList<String>(attributeOrder.length);
        for (String name : attributeOrder) {
            Optional<Field> field = fields.stream().filter(f -> f.getName().equals(name)).findFirst();
            if (field.isEmpty()) {
                throw new JsonLdDeserializationException("Field called " + name + " declared in JsonLdAttributeOrder annotation not found in class " + cls + ".");
            }
            propertyOrder.add(BeanAnnotationProcessor.getAttributeIdentifier(field.get()));
        }
        return propertyOrder;
    }

    private boolean shouldSkipProperty(String property) {
        if ("@id".equals(property)) {
            return true;
        }
        if (!this.instanceBuilder.isPropertyDeserializable(property)) {
            this.throwUnknownPropertyIfNotIgnored(property);
            return true;
        }
        return false;
    }

    private void throwUnknownPropertyIfNotIgnored(String property) {
        if (!this.instanceBuilder.isPropertyMapped(property) && !this.configuration().is(ConfigParam.IGNORE_UNKNOWN_PROPERTIES)) {
            throw UnknownPropertyException.create(property, this.instanceBuilder.getCurrentContextType());
        }
    }
}

