/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.reference;

import cz.cvut.kbss.jsonld.deserialization.reference.CollectionPendingReference;
import cz.cvut.kbss.jsonld.deserialization.reference.PendingReference;
import cz.cvut.kbss.jsonld.deserialization.reference.SingularPendingReference;
import cz.cvut.kbss.jsonld.exception.UnresolvedReferenceException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PendingReferenceRegistry {
    private final Map<String, Set<PendingReference>> pendingReferences = new HashMap<String, Set<PendingReference>>();

    public void addPendingReference(String identifier, Object targetObject, Field targetField) {
        assert (identifier != null);
        assert (targetObject != null);
        assert (targetField != null);
        this.addReference(identifier, new SingularPendingReference(targetObject, targetField));
    }

    private void addReference(String identifier, PendingReference reference) {
        Set refs = this.pendingReferences.computeIfAbsent(identifier, id -> new HashSet());
        refs.add(reference);
    }

    public void addPendingReference(String identifier, Collection targetObject) {
        assert (identifier != null);
        assert (targetObject != null);
        this.addReference(identifier, new CollectionPendingReference(targetObject));
    }

    public void resolveReferences(String identifier, Object referencedObject) {
        assert (identifier != null);
        assert (referencedObject != null);
        Set<PendingReference> refs = this.pendingReferences.remove(identifier);
        if (refs != null) {
            refs.forEach(pr -> pr.apply(referencedObject));
        }
    }

    public void verifyNoUnresolvedReferencesExist() {
        if (!this.pendingReferences.isEmpty()) {
            throw new UnresolvedReferenceException("There are unresolved references to objects " + this.pendingReferences.keySet());
        }
    }
}

