/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.reference;

import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.deserialization.reference.PendingReference;
import cz.cvut.kbss.jsonld.exception.TargetTypeException;
import java.lang.reflect.Field;
import java.util.Objects;

public final class SingularPendingReference
implements PendingReference {
    private final Object targetObject;
    private final Field targetField;

    public SingularPendingReference(Object targetObject, Field targetField) {
        this.targetObject = Objects.requireNonNull(targetObject);
        this.targetField = Objects.requireNonNull(targetField);
    }

    @Override
    public void apply(Object referencedObject) {
        assert (referencedObject != null);
        if (!this.targetField.getType().isAssignableFrom(referencedObject.getClass())) {
            throw new TargetTypeException("Cannot assign referenced object " + referencedObject + " of type " + referencedObject.getClass() + " to field " + this.targetField);
        }
        BeanClassProcessor.setFieldValue(this.targetField, this.targetObject, referencedObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularPendingReference that = (SingularPendingReference)o;
        return this.targetObject.equals(that.targetObject) && this.targetField.equals(that.targetField);
    }

    public int hashCode() {
        return Objects.hash(this.targetObject, this.targetField);
    }
}

