/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.util;

import cz.cvut.kbss.jsonld.exception.JsonLdException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathScanner.class);
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private final Consumer<Class<?>> listener;

    public ClasspathScanner(Consumer<Class<?>> listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    public void processClasses(String scanPath) {
        if (scanPath == null) {
            scanPath = "";
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = loader.getResources(scanPath.replace('.', '/'));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (ClasspathScanner.isJar(url.toString())) {
                    this.processJarFile(url, scanPath);
                    continue;
                }
                this.processDirectory(new File(ClasspathScanner.getUrlAsUri(url).getPath()), scanPath);
            }
            Enumeration<URL> resources = loader.getResources(".");
            while (resources.hasMoreElements()) {
                URL resourceURL = resources.nextElement();
                if (!ClasspathScanner.isJar(resourceURL.toString())) continue;
                this.processJarFile(resourceURL, scanPath);
            }
        }
        catch (IOException e) {
            throw new JsonLdException("Unable to scan packages.", e);
        }
    }

    private static boolean isJar(String filePath) {
        return filePath.startsWith("jar:") || filePath.endsWith(JAR_FILE_SUFFIX);
    }

    private static URI getUrlAsUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new JsonLdException("Unable to scan resource " + url + ". It is not a valid URI.", ex);
        }
    }

    protected void processJarFile(URL jarResource, String packageName) {
        String relPath = packageName.replace('.', '/');
        String jarPath = jarResource.getPath().replaceFirst("[.]jar/?!.*", JAR_FILE_SUFFIX).replaceFirst("file:", "").replaceFirst("nested:", "");
        LOG.trace("Scanning jar file {} for classes.", (Object)jarPath);
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                String className = null;
                if (ClasspathScanner.shouldSkipEntry(entryName)) continue;
                if (entryName.endsWith(CLASS_FILE_SUFFIX) && entryName.contains(relPath)) {
                    className = entryName.replaceFirst("META-INF/versions/[1-9][0-9]*/", "");
                    className = className.replaceFirst("WEB-INF/classes/", "");
                    className = className.replaceFirst("BOOT-INF/classes/", "");
                    className = className.replace('/', '.').replace('\\', '.');
                    className = className.substring(0, className.length() - CLASS_FILE_SUFFIX.length());
                }
                if (className == null) continue;
                this.processClass(className);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to scan classes in JAR file " + jarPath, (Throwable)e);
        }
    }

    private static boolean shouldSkipEntry(String entryName) {
        return entryName.endsWith("module-info.class");
    }

    private void processClass(String className) {
        try {
            Class<?> cls = Class.forName(className);
            this.listener.accept(cls);
        }
        catch (Throwable e) {
            LOG.debug("Skipping non-loadable class {}, got error {}: {}.", new Object[]{className, e.getClass().getName(), e.getMessage()});
        }
    }

    private void processDirectory(File dir, String packageName) throws MalformedURLException {
        LOG.trace("Scanning directory {}.", (Object)dir);
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (String fileName : files) {
            File subDir;
            String className = null;
            if (fileName.endsWith(CLASS_FILE_SUFFIX)) {
                className = packageName + "." + fileName.substring(0, fileName.length() - 6);
            }
            if (className != null) {
                this.processClass(className);
            }
            if ((subDir = new File(dir, fileName)).isDirectory()) {
                this.processDirectory(subDir, packageName + (Serializable)(!packageName.isEmpty() ? Character.valueOf('.') : "") + fileName);
                continue;
            }
            if (!ClasspathScanner.isJar(subDir.getAbsolutePath())) continue;
            this.processJarFile(subDir.toURI().toURL(), packageName);
        }
    }
}

