/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.util;

import cz.cvut.kbss.jopa.datatype.DatatypeTransformer;
import cz.cvut.kbss.jopa.datatype.util.Pair;
import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jsonld.common.EnumUtil;
import cz.cvut.kbss.jsonld.deserialization.util.LangString;
import cz.cvut.kbss.jsonld.exception.InvalidEnumMappingException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class DataTypeTransformer {
    private static final Map<Pair, Function<Object, ?>> CUSTOM_TRANSFORMERS = DataTypeTransformer.initCustomTransformers();

    private static Map<Pair, Function<Object, ?>> initCustomTransformers() {
        HashMap map = new HashMap();
        map.put(new Pair(LangString.class, MultilingualString.class), src -> {
            LangString ls = (LangString)((Object)((Object)src));
            return new MultilingualString(Collections.singletonMap(ls.getLanguage().orElse(null), ls.getValue()));
        });
        map.put(new Pair(String.class, MultilingualString.class), src -> new MultilingualString(Collections.singletonMap(null, src.toString())));
        map.put(new Pair(OffsetDateTime.class, LocalDateTime.class), src -> ((OffsetDateTime)src).toLocalDateTime());
        map.put(new Pair(OffsetDateTime.class, ZonedDateTime.class), src -> ((OffsetDateTime)src).toZonedDateTime());
        map.put(new Pair(OffsetDateTime.class, Instant.class), src -> ((OffsetDateTime)src).toInstant());
        map.put(new Pair(OffsetDateTime.class, Date.class), src -> Date.from(((OffsetDateTime)src).toInstant()));
        map.put(new Pair(OffsetTime.class, LocalTime.class), src -> ((OffsetTime)src).toLocalTime());
        return map;
    }

    public static <T> T transformValue(Object value, Class<T> targetClass) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(targetClass);
        Class<?> sourceClass = value.getClass();
        if (targetClass.isAssignableFrom(sourceClass)) {
            return targetClass.cast(value);
        }
        if (targetClass.isEnum()) {
            return DataTypeTransformer.transformLiteralToEnumConstant(value, targetClass);
        }
        Pair key = new Pair(sourceClass, targetClass);
        if (CUSTOM_TRANSFORMERS.containsKey(key)) {
            return targetClass.cast(CUSTOM_TRANSFORMERS.get(key).apply(value));
        }
        return (T)DatatypeTransformer.transform((Object)value, targetClass);
    }

    private static <T extends Enum<T>> T transformLiteralToEnumConstant(Object value, Class<T> targetClass) {
        return Enum.valueOf(targetClass, value.toString());
    }

    public static <T extends Enum<T>> T transformIndividualToEnumConstant(String identifier, Class<T> targetClass) {
        return (T)EnumUtil.findMatchingConstant(targetClass, (e, iri) -> iri.equals(identifier), (e, iri) -> e).orElseThrow(() -> new InvalidEnumMappingException("No matching constant found for individual <" + identifier + "> in target class " + targetClass));
    }
}

