/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.util;

import cz.cvut.kbss.jopa.model.annotations.OWLClass;
import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.deserialization.util.TargetClassResolverConfig;
import cz.cvut.kbss.jsonld.deserialization.util.TypeMap;
import cz.cvut.kbss.jsonld.exception.AmbiguousTargetTypeException;
import cz.cvut.kbss.jsonld.exception.TargetTypeException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TargetClassResolver.class);
    private final TypeMap typeMap;
    private final TargetClassResolverConfig config;

    public TargetClassResolver(TypeMap typeMap) {
        this.typeMap = typeMap;
        this.config = new TargetClassResolverConfig();
    }

    public TargetClassResolver(TypeMap typeMap, TargetClassResolverConfig config) {
        this.typeMap = typeMap;
        this.config = config;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Class<? extends T> getTargetClass(Class<T> expectedClass, Collection<String> types) {
        void var4_7;
        if (types.isEmpty() && this.config.shouldAllowAssumingTargetType()) {
            LOG.trace("Assuming target type to be " + expectedClass);
            return expectedClass;
        }
        List<Class<?>> candidates = this.getTargetClassCandidates(types);
        this.reduceTargetClassCandidates(expectedClass, candidates);
        ArrayList reducedCandidates = new ArrayList(candidates);
        this.reduceToMostSpecificSubclasses(candidates);
        if (candidates.isEmpty()) {
            if (!this.doesExpectedClassMatchesTypes(expectedClass, types)) throw new TargetTypeException("Neither " + expectedClass + " nor any of its subclasses matches the types " + types + ".");
            Class<T> clazz = expectedClass;
        } else {
            Class<?> clazz = this.selectFinalTargetClass(candidates, reducedCandidates, types);
        }
        assert (expectedClass.isAssignableFrom((Class<?>)var4_7));
        return var4_7;
    }

    private List<Class<?>> getTargetClassCandidates(Collection<String> types) {
        return types.stream().flatMap(t -> this.typeMap.get((String)t).stream()).collect(Collectors.toList());
    }

    private void reduceTargetClassCandidates(Class<?> expectedClass, List<Class<?>> candidates) {
        candidates.removeIf(c -> !expectedClass.isAssignableFrom((Class<?>)c) || Modifier.isAbstract(c.getModifiers()));
    }

    private void reduceToMostSpecificSubclasses(List<Class<?>> candidates) {
        candidates.removeIf(cls -> candidates.stream().anyMatch(c -> !cls.equals(c) && cls.isAssignableFrom((Class<?>)c)));
    }

    private Class<?> selectFinalTargetClass(List<Class<?>> mostSpecificCandidates, List<Class<?>> candidates, Collection<String> types) {
        assert (mostSpecificCandidates.size() > 0);
        if (mostSpecificCandidates.size() > 1) {
            if (!this.config.isOptimisticTypeResolutionEnabled()) {
                throw TargetClassResolver.ambiguousTargetType(types, mostSpecificCandidates);
            }
            if (this.config.shouldPreferSuperclass()) {
                return this.selectTargetClassWithSuperclassPreference(mostSpecificCandidates, candidates);
            }
        }
        return TargetClassResolver.pickOne(mostSpecificCandidates);
    }

    private static Class<?> pickOne(List<Class<?>> candidates) {
        return candidates.size() == 1 ? candidates.get(0) : candidates.stream().filter(BeanAnnotationProcessor::hasPropertiesField).findFirst().orElse(candidates.get(0));
    }

    private Class<?> selectTargetClassWithSuperclassPreference(List<Class<?>> mostSpecificCandidates, List<Class<?>> candidates) {
        candidates.removeAll(mostSpecificCandidates);
        this.reduceToMostGeneralSuperclasses(candidates);
        return TargetClassResolver.pickOne(candidates);
    }

    private void reduceToMostGeneralSuperclasses(List<Class<?>> candidates) {
        candidates.removeIf(cls -> candidates.stream().anyMatch(c -> !cls.equals(c) && c.isAssignableFrom((Class<?>)cls)));
    }

    private static AmbiguousTargetTypeException ambiguousTargetType(Collection<String> types, List<Class<?>> candidates) {
        return new AmbiguousTargetTypeException("Object with types " + types + " matches multiple equivalent target classes: " + candidates);
    }

    private boolean doesExpectedClassMatchesTypes(Class<?> expectedClass, Collection<String> types) {
        OWLClass owlClass = expectedClass.getDeclaredAnnotation(OWLClass.class);
        return owlClass != null && types.contains(owlClass.iri());
    }
}

