/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.deserialization.util;

import cz.cvut.kbss.jsonld.exception.JsonLdDeserializationException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;

public class ValueUtils {
    private ValueUtils() {
        throw new AssertionError();
    }

    public static JsonValue getValue(JsonValue jsonNode) {
        if (jsonNode.getValueType() != JsonValue.ValueType.OBJECT || !jsonNode.asJsonObject().containsKey((Object)"@value")) {
            throw new JsonLdDeserializationException("Cannot deserialize node " + jsonNode + "as literal. It is missing attribute '@value'.");
        }
        return (JsonValue)jsonNode.asJsonObject().get((Object)"@value");
    }

    public static String stringValue(JsonValue value) {
        return value instanceof JsonString ? ((JsonString)value).getString() : value.toString();
    }

    public static Object literalValue(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).numberValue();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException("Value " + value + " is not a literal.");
    }
}

