/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization;

import cz.cvut.kbss.jsonld.ConfigParam;
import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.serialization.JsonGenerator;
import cz.cvut.kbss.jsonld.serialization.JsonLdSerializer;
import cz.cvut.kbss.jsonld.serialization.JsonLdTreeBuilder;
import cz.cvut.kbss.jsonld.serialization.context.DummyJsonLdContext;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.serializer.LiteralValueSerializers;
import cz.cvut.kbss.jsonld.serialization.serializer.ObjectGraphValueSerializers;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializers;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.DefaultValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.IdentifierSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.IndividualSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.MultilingualStringSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.ObjectPropertyValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.TypesSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.datetime.TemporalAmountSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.datetime.TemporalSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.datetime.DateSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.ObjectGraphTraverser;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContextFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Date;

public class CompactedJsonLdSerializer
extends JsonLdSerializer {
    public CompactedJsonLdSerializer(JsonGenerator jsonGenerator) {
        super(jsonGenerator);
    }

    public CompactedJsonLdSerializer(JsonGenerator jsonGenerator, Configuration configuration) {
        super(jsonGenerator, configuration);
    }

    @Override
    protected ValueSerializers initSerializers() {
        LiteralValueSerializers valueSerializers = new LiteralValueSerializers(new DefaultValueSerializer(new MultilingualStringSerializer()));
        valueSerializers.registerIdentifierSerializer(new IdentifierSerializer());
        valueSerializers.registerTypesSerializer(new TypesSerializer());
        valueSerializers.registerIndividualSerializer(new IndividualSerializer());
        TemporalSerializer ts = new TemporalSerializer();
        valueSerializers.registerSerializer(LocalDate.class, ts);
        valueSerializers.registerSerializer(LocalDate.class, ts);
        valueSerializers.registerSerializer(LocalTime.class, ts);
        valueSerializers.registerSerializer(OffsetTime.class, ts);
        valueSerializers.registerSerializer(LocalDateTime.class, ts);
        valueSerializers.registerSerializer(OffsetDateTime.class, ts);
        valueSerializers.registerSerializer(ZonedDateTime.class, ts);
        valueSerializers.registerSerializer(Instant.class, ts);
        valueSerializers.registerSerializer(Date.class, new DateSerializer(ts));
        TemporalAmountSerializer tas = new TemporalAmountSerializer();
        valueSerializers.registerSerializer(Duration.class, tas);
        valueSerializers.registerSerializer(Period.class, tas);
        return valueSerializers;
    }

    @Override
    protected JsonNode buildJsonTree(Object root) {
        ObjectGraphTraverser traverser = new ObjectGraphTraverser(new SerializationContextFactory(DummyJsonLdContext.INSTANCE));
        traverser.setRequireId(this.configuration().is(ConfigParam.REQUIRE_ID));
        JsonLdTreeBuilder treeBuilder = this.initTreeBuilder(traverser);
        traverser.setVisitor(treeBuilder);
        traverser.traverse(root);
        return treeBuilder.getTreeRoot();
    }

    private JsonLdTreeBuilder initTreeBuilder(ObjectGraphTraverser traverser) {
        ObjectPropertyValueSerializer opSerializer = new ObjectPropertyValueSerializer(traverser);
        opSerializer.configure(this.configuration());
        return new JsonLdTreeBuilder(new ObjectGraphValueSerializers(this.serializers, opSerializer), DummyJsonLdContext.INSTANCE);
    }
}

