/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization;

import cz.cvut.kbss.jsonld.ConfigParam;
import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.exception.AmbiguousTermMappingException;
import cz.cvut.kbss.jsonld.serialization.JsonGenerator;
import cz.cvut.kbss.jsonld.serialization.JsonLdSerializer;
import cz.cvut.kbss.jsonld.serialization.JsonLdTreeBuilder;
import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.context.JsonLdContext;
import cz.cvut.kbss.jsonld.serialization.context.JsonLdContextFactory;
import cz.cvut.kbss.jsonld.serialization.context.MappingJsonLdContextFactory;
import cz.cvut.kbss.jsonld.serialization.model.CompositeNode;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.model.SetNode;
import cz.cvut.kbss.jsonld.serialization.serializer.LiteralValueSerializers;
import cz.cvut.kbss.jsonld.serialization.serializer.ObjectGraphValueSerializers;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializers;
import cz.cvut.kbss.jsonld.serialization.serializer.context.ContextBuildingDefaultValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.ContextBuildingIdentifierSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.ContextBuildingIndividualSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.ContextBuildingMultilingualStringSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.ContextBuildingObjectPropertyValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.ContextBuildingPluralMultilingualStringSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.ContextBuildingTypesSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.datetime.ContextBuildingTemporalAmountSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.context.datetime.ContextBuildingTemporalSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.datetime.DateSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.ObjectGraphTraverser;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContextFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;

public class ContextBuildingJsonLdSerializer
extends JsonLdSerializer {
    ContextBuildingJsonLdSerializer(JsonGenerator jsonGenerator) {
        super(jsonGenerator);
    }

    ContextBuildingJsonLdSerializer(JsonGenerator jsonGenerator, Configuration configuration) {
        super(jsonGenerator, configuration);
    }

    @Override
    protected ValueSerializers initSerializers() {
        ContextBuildingMultilingualStringSerializer mlsSerializer = new ContextBuildingMultilingualStringSerializer();
        ContextBuildingPluralMultilingualStringSerializer mlsColSerializer = new ContextBuildingPluralMultilingualStringSerializer();
        LiteralValueSerializers valueSerializers = new LiteralValueSerializers(new ContextBuildingDefaultValueSerializer(mlsSerializer, mlsColSerializer));
        valueSerializers.registerIdentifierSerializer(new ContextBuildingIdentifierSerializer());
        valueSerializers.registerTypesSerializer(new ContextBuildingTypesSerializer());
        valueSerializers.registerIndividualSerializer(new ContextBuildingIndividualSerializer());
        ContextBuildingTemporalSerializer ts = new ContextBuildingTemporalSerializer();
        valueSerializers.registerSerializer(LocalDate.class, ts);
        valueSerializers.registerSerializer(LocalDate.class, ts);
        valueSerializers.registerSerializer(LocalTime.class, ts);
        valueSerializers.registerSerializer(OffsetTime.class, ts);
        valueSerializers.registerSerializer(LocalDateTime.class, ts);
        valueSerializers.registerSerializer(OffsetDateTime.class, ts);
        valueSerializers.registerSerializer(ZonedDateTime.class, ts);
        valueSerializers.registerSerializer(Instant.class, ts);
        valueSerializers.registerSerializer(Date.class, new DateSerializer(ts));
        ContextBuildingTemporalAmountSerializer tas = new ContextBuildingTemporalAmountSerializer();
        valueSerializers.registerSerializer(Duration.class, tas);
        valueSerializers.registerSerializer(Period.class, tas);
        return valueSerializers;
    }

    @Override
    protected JsonNode buildJsonTree(Object root) {
        MappingJsonLdContextFactory jsonLdContextFactory = new MappingJsonLdContextFactory();
        JsonLdContext rootContext = jsonLdContextFactory.createJsonLdContext();
        ObjectGraphTraverser traverser = new ObjectGraphTraverser(new SerializationContextFactory(rootContext));
        traverser.setRequireId(this.configuration().is(ConfigParam.REQUIRE_ID));
        if (root instanceof Collection) {
            return this.buildObjectWithContextAndGraph(traverser, rootContext, jsonLdContextFactory, (Collection)root);
        }
        JsonLdTreeBuilder treeBuilder = this.initTreeBuilder(traverser, jsonLdContextFactory);
        traverser.setVisitor(treeBuilder);
        traverser.traverse(root);
        this.ensureContextNodeNotPresent(treeBuilder.getTreeRoot(), rootContext.getContextNode());
        treeBuilder.getTreeRoot().prependItem(rootContext.getContextNode());
        return treeBuilder.getTreeRoot();
    }

    private void ensureContextNodeNotPresent(CompositeNode<?> root, JsonNode rootCtx) {
        Optional<JsonNode> ctxNode = root.getItems().stream().filter(n -> "@context".equals(n.getName())).findAny();
        if (ctxNode.isPresent()) {
            throw new AmbiguousTermMappingException("Unable to build context hierarchy. Attempted to add two root contexts. Original root context: " + rootCtx + ", conflicting: " + ctxNode.get());
        }
    }

    private JsonLdTreeBuilder initTreeBuilder(ObjectGraphTraverser traverser, JsonLdContextFactory jsonLdContextFactory) {
        ContextBuildingObjectPropertyValueSerializer opSerializer = new ContextBuildingObjectPropertyValueSerializer(traverser);
        opSerializer.configure(this.configuration());
        return new JsonLdTreeBuilder(new ObjectGraphValueSerializers(this.serializers, opSerializer), jsonLdContextFactory);
    }

    private JsonNode buildObjectWithContextAndGraph(ObjectGraphTraverser traverser, JsonLdContext rootContext, JsonLdContextFactory jsonLdContextFactory, Collection<?> items) {
        SetNode graph = JsonNodeFactory.createCollectionNodeFromArray("@graph");
        items.stream().map(item -> {
            JsonLdTreeBuilder treeBuilder = this.initTreeBuilder(traverser, jsonLdContextFactory);
            traverser.setVisitor(treeBuilder);
            traverser.traverse(item);
            return treeBuilder.getTreeRoot();
        }).forEach(graph::addItem);
        ObjectNode result = JsonNodeFactory.createObjectNode();
        result.addItem(rootContext.getContextNode());
        result.addItem(graph);
        return result;
    }
}

