/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization;

import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.common.Configured;
import cz.cvut.kbss.jsonld.serialization.CompactedJsonLdSerializer;
import cz.cvut.kbss.jsonld.serialization.ContextBuildingJsonLdSerializer;
import cz.cvut.kbss.jsonld.serialization.JsonGenerator;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializers;
import java.util.Objects;

public abstract class JsonLdSerializer
implements Configured {
    private final Configuration configuration;
    protected final JsonGenerator jsonGenerator;
    protected final ValueSerializers serializers;

    protected JsonLdSerializer(JsonGenerator jsonGenerator) {
        this.jsonGenerator = Objects.requireNonNull(jsonGenerator);
        this.configuration = new Configuration();
        this.serializers = this.initSerializers();
    }

    public JsonLdSerializer(JsonGenerator jsonGenerator, Configuration configuration) {
        this.jsonGenerator = Objects.requireNonNull(jsonGenerator);
        this.configuration = Objects.requireNonNull(configuration);
        this.serializers = this.initSerializers();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    public <T> void registerSerializer(Class<T> type, ValueSerializer<T> serializer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(serializer);
        this.serializers.registerSerializer(type, serializer);
    }

    public void serialize(Object root) {
        Objects.requireNonNull(root);
        this.serializers.configure(this.configuration);
        JsonNode jsonRoot = this.buildJsonTree(root);
        jsonRoot.write(this.jsonGenerator);
    }

    protected abstract ValueSerializers initSerializers();

    protected abstract JsonNode buildJsonTree(Object var1);

    public static JsonLdSerializer createCompactedJsonLdSerializer(JsonGenerator jsonWriter) {
        return new CompactedJsonLdSerializer(jsonWriter);
    }

    public static JsonLdSerializer createCompactedJsonLdSerializer(JsonGenerator jsonWriter, Configuration configuration) {
        return new CompactedJsonLdSerializer(jsonWriter, configuration);
    }

    public static JsonLdSerializer createContextBuildingJsonLdSerializer(JsonGenerator jsonWriter) {
        return new ContextBuildingJsonLdSerializer(jsonWriter);
    }

    public static JsonLdSerializer createContextBuildingJsonLdSerializer(JsonGenerator jsonWriter, Configuration configuration) {
        return new ContextBuildingJsonLdSerializer(jsonWriter, configuration);
    }
}

