/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization;

import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.context.JsonLdContextFactory;
import cz.cvut.kbss.jsonld.serialization.model.CollectionNode;
import cz.cvut.kbss.jsonld.serialization.model.CompositeNode;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializers;
import cz.cvut.kbss.jsonld.serialization.traversal.InstanceVisitor;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;

public class JsonLdTreeBuilder
implements InstanceVisitor {
    private final Stack<CompositeNode<?>> nodeStack = new Stack();
    private CompositeNode<?> currentNode;
    private final ValueSerializers serializers;
    private final JsonLdContextFactory jsonLdContextFactory;

    public JsonLdTreeBuilder(ValueSerializers serializers, JsonLdContextFactory jsonLdContextFactory) {
        this.serializers = serializers;
        this.jsonLdContextFactory = jsonLdContextFactory;
    }

    @Override
    public void visitIndividual(SerializationContext<?> ctx) {
        ValueSerializer<?> s = this.serializers.getIndividualSerializer();
        JsonNode node = s.serialize(ctx.getValue(), ctx);
        if (this.currentNode != null) {
            this.currentNode.addItem(node);
        } else {
            assert (node instanceof CompositeNode);
            this.currentNode = (CompositeNode)node;
        }
    }

    @Override
    public boolean visitObject(SerializationContext<?> ctx) {
        if (this.serializers.hasCustomSerializer(ctx.getValue().getClass())) {
            ValueSerializer<?> serializer = this.serializers.getSerializer(ctx).get();
            JsonNode node = serializer.serialize(ctx.getValue(), ctx);
            if (node != null) {
                if (this.currentNode != null) {
                    this.currentNode.addItem(node);
                } else {
                    assert (node instanceof CompositeNode);
                    this.currentNode = (CompositeNode)node;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void openObject(SerializationContext<?> ctx) {
        ObjectNode newCurrent = JsonNodeFactory.createObjectNode(ctx.getTerm());
        this.openNewNode(newCurrent);
        ctx.setJsonLdContext(this.jsonLdContextFactory.createJsonLdContext(ctx.getJsonLdContext()));
    }

    private void openNewNode(CompositeNode<?> newNode) {
        if (this.currentNode != null) {
            if (this.currentNode.isOpen()) {
                this.nodeStack.push(this.currentNode);
            }
            this.currentNode.addItem(newNode);
        }
        this.currentNode = newNode;
    }

    @Override
    public void closeObject(SerializationContext<?> ctx) {
        if (!ctx.isCurrentEmpty()) {
            this.currentNode.prependItem(ctx.getContextNode());
        }
        this.closeCurrentNode();
    }

    private void closeCurrentNode() {
        this.currentNode.close();
        if (!this.nodeStack.empty()) {
            this.currentNode = this.nodeStack.pop();
        }
    }

    @Override
    public void visitIdentifier(SerializationContext<String> idCtx) {
        assert (this.currentNode.isOpen());
        this.currentNode.addItem(this.serializers.getIdentifierSerializer().serialize(idCtx.getValue(), idCtx));
    }

    @Override
    public void visitTypes(SerializationContext<Set<String>> typesCtx) {
        this.currentNode.addItem(this.serializers.getTypesSerializer().serialize(typesCtx.getValue(), typesCtx));
    }

    @Override
    public void visitAttribute(SerializationContext<?> ctx) {
        if (ctx.getValue() != null) {
            assert (this.currentNode != null);
            ValueSerializer<?> serializer = this.serializers.getOrDefault(ctx);
            JsonNode node = serializer.serialize(ctx.getValue(), ctx);
            if (node != null) {
                this.currentNode.addItem(node);
            }
        }
    }

    @Override
    public void openCollection(SerializationContext<? extends Collection<?>> ctx) {
        CollectionNode<?> newCurrent = JsonNodeFactory.createCollectionNode(ctx.getTerm(), ctx.getValue());
        this.openNewNode(newCurrent);
    }

    @Override
    public void closeCollection(SerializationContext<?> ctx) {
        assert (this.currentNode instanceof CollectionNode);
        this.closeCurrentNode();
    }

    public CompositeNode<?> getTreeRoot() {
        return this.currentNode;
    }
}

