/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization;

import cz.cvut.kbss.jsonld.common.CollectionType;
import cz.cvut.kbss.jsonld.serialization.model.BooleanLiteralNode;
import cz.cvut.kbss.jsonld.serialization.model.CollectionNode;
import cz.cvut.kbss.jsonld.serialization.model.ListNode;
import cz.cvut.kbss.jsonld.serialization.model.LiteralNode;
import cz.cvut.kbss.jsonld.serialization.model.NumericLiteralNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectIdNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.model.SetNode;
import cz.cvut.kbss.jsonld.serialization.model.StringLiteralNode;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class JsonNodeFactory {
    private JsonNodeFactory() {
        throw new AssertionError();
    }

    public static LiteralNode<?> createLiteralNode(Object value) {
        return JsonNodeFactory.createLiteralNode(null, value);
    }

    public static LiteralNode<?> createLiteralNode(String name, Object value) {
        LiteralType type = JsonNodeFactory.determineLiteralType(value);
        switch (type) {
            case BOOLEAN: {
                return JsonNodeFactory.createBooleanLiteralNode(name, (Boolean)value);
            }
            case NUMBER: {
                return JsonNodeFactory.createNumericLiteralNode(name, (Number)value);
            }
        }
        return JsonNodeFactory.createStringLiteralNode(name, value.toString());
    }

    private static LiteralType determineLiteralType(Object value) {
        if (value instanceof Boolean) {
            return LiteralType.BOOLEAN;
        }
        if (value instanceof Number) {
            return LiteralType.NUMBER;
        }
        return LiteralType.STRING;
    }

    public static BooleanLiteralNode createBooleanLiteralNode(String name, Boolean value) {
        return name != null ? new BooleanLiteralNode(name, value) : new BooleanLiteralNode(value);
    }

    public static NumericLiteralNode<Number> createNumericLiteralNode(String name, Number value) {
        return name != null ? new NumericLiteralNode<Number>(name, value) : new NumericLiteralNode<Number>(value);
    }

    public static StringLiteralNode createStringLiteralNode(String name, String value) {
        return name != null ? new StringLiteralNode(name, value) : new StringLiteralNode(value);
    }

    public static CollectionNode<?> createCollectionNode(String name, Collection<?> value) {
        CollectionType type = JsonNodeFactory.determineCollectionType(value);
        switch (type) {
            case LIST: {
                return new ListNode(name);
            }
            case SET: {
                return JsonNodeFactory.createSetNode(name);
            }
        }
        throw new IllegalArgumentException("Unsupported collection type " + type);
    }

    private static CollectionType determineCollectionType(Collection<?> collection) {
        if (collection instanceof List) {
            return CollectionType.LIST;
        }
        if (collection instanceof Set) {
            return CollectionType.SET;
        }
        throw new IllegalArgumentException("Unsupported collection type " + collection.getClass());
    }

    public static SetNode createSetNode(String name) {
        return new SetNode(name);
    }

    public static SetNode createCollectionNodeFromArray(String name) {
        return JsonNodeFactory.createSetNode(name);
    }

    public static ObjectNode createObjectNode() {
        return new ObjectNode();
    }

    public static ObjectNode createObjectNode(String name) {
        return new ObjectNode(name);
    }

    public static ObjectIdNode createObjectIdNode(String name, Object id) {
        return new ObjectIdNode(name, id.toString());
    }

    private static enum LiteralType {
        BOOLEAN,
        NUMBER,
        STRING;

    }
}

