/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.context;

import cz.cvut.kbss.jsonld.exception.AmbiguousTermMappingException;
import cz.cvut.kbss.jsonld.serialization.context.DummyTermMappingHolder;
import cz.cvut.kbss.jsonld.serialization.context.TermMappingHolder;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class EmbeddedTermMappingHolder
extends TermMappingHolder {
    private final Map<String, JsonNode> mapping = new HashMap<String, JsonNode>();

    EmbeddedTermMappingHolder() {
        super(DummyTermMappingHolder.INSTANCE);
    }

    EmbeddedTermMappingHolder(TermMappingHolder parentContext) {
        super(parentContext);
    }

    @Override
    boolean canRegisterTermMapping(String term, JsonNode mappedNode) {
        return true;
    }

    @Override
    void registerTermMapping(String term, JsonNode mappedNode) {
        Objects.requireNonNull(term);
        Objects.requireNonNull(mappedNode);
        if (this.parentContext.hasTermMapping(term, mappedNode)) {
            return;
        }
        if (!this.isRoot() && !this.parentContext.hasTermMapping(term)) {
            this.parentContext.registerTermMapping(term, mappedNode);
        } else {
            this.verifyMappingUnique(term, mappedNode);
            this.mapping.put(term, mappedNode);
        }
    }

    @Override
    boolean isRoot() {
        return this.parentContext == DummyTermMappingHolder.INSTANCE;
    }

    private void verifyMappingUnique(String term, JsonNode value) {
        if (this.mapping.containsKey(term) && !Objects.equals(this.mapping.get(term), value)) {
            throw new AmbiguousTermMappingException("Context already contains mapping for term '" + term + "'.");
        }
    }

    @Override
    public Map<String, JsonNode> getMapping() {
        return Collections.unmodifiableMap(this.mapping);
    }

    @Override
    public Optional<JsonNode> getTermMapping(String term) {
        return this.mapping.containsKey(term) ? Optional.of(this.mapping.get(term)) : this.parentContext.getTermMapping(term);
    }

    @Override
    public boolean hasTermMapping(String term) {
        return this.mapping.containsKey(term) || this.parentContext.hasTermMapping(term);
    }

    @Override
    boolean hasTermMapping(String term, JsonNode mappedNode) {
        return this.mapping.containsKey(term) && this.mapping.get(term).equals(mappedNode);
    }

    @Override
    public Optional<String> getMappedTerm(String iri) {
        Optional<String> result = super.getMappedTerm(iri);
        if (result.isPresent()) {
            return result;
        }
        return this.parentContext.getMappedTerm(iri);
    }

    @Override
    boolean isEmpty() {
        return this.mapping.isEmpty();
    }
}

