/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.context;

import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.context.EmbeddedTermMappingHolder;
import cz.cvut.kbss.jsonld.serialization.context.JsonLdContext;
import cz.cvut.kbss.jsonld.serialization.context.TermMappingHolder;
import cz.cvut.kbss.jsonld.serialization.context.WriteThroughTermMappingHolder;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.model.StringLiteralNode;
import java.util.Optional;

public class MappingJsonLdContext
implements JsonLdContext {
    private TermMappingHolder mappingHolder;

    public MappingJsonLdContext() {
        this.mappingHolder = new EmbeddedTermMappingHolder();
    }

    public MappingJsonLdContext(JsonLdContext parent) {
        assert (parent instanceof MappingJsonLdContext);
        this.mappingHolder = new WriteThroughTermMappingHolder(((MappingJsonLdContext)parent).mappingHolder);
    }

    @Override
    public void registerTermMapping(String term, String iri) {
        StringLiteralNode value = JsonNodeFactory.createStringLiteralNode(term, iri);
        if (!this.mappingHolder.canRegisterTermMapping(term, value) && !this.mappingHolder.isRoot()) {
            this.mappingHolder = new EmbeddedTermMappingHolder(this.mappingHolder);
        }
        this.mappingHolder.registerTermMapping(term, value);
    }

    @Override
    public void registerTermMapping(String term, ObjectNode mappedNode) {
        if (!this.mappingHolder.canRegisterTermMapping(term, mappedNode) && !this.mappingHolder.isRoot()) {
            this.mappingHolder = new EmbeddedTermMappingHolder(this.mappingHolder);
        }
        this.mappingHolder.registerTermMapping(term, mappedNode);
    }

    @Override
    public Optional<JsonNode> getTermMapping(String term) {
        return this.mappingHolder.getTermMapping(term);
    }

    @Override
    public boolean hasTermMapping(String term) {
        return this.mappingHolder.hasTermMapping(term);
    }

    @Override
    public Optional<String> getMappedTerm(String iri) {
        return this.mappingHolder.getMappedTerm(iri);
    }

    @Override
    public boolean isCurrentEmpty() {
        return this.mappingHolder.isEmpty();
    }

    @Override
    public ObjectNode getContextNode() {
        ObjectNode node = new ObjectNode("@context");
        this.mappingHolder.getMapping().values().forEach(node::addItem);
        return node;
    }
}

