/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.context;

import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.model.StringLiteralNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

abstract class TermMappingHolder {
    final TermMappingHolder parentContext;

    TermMappingHolder(TermMappingHolder parentContext) {
        this.parentContext = parentContext;
    }

    abstract boolean canRegisterTermMapping(String var1, JsonNode var2);

    abstract void registerTermMapping(String var1, JsonNode var2);

    abstract Optional<JsonNode> getTermMapping(String var1);

    abstract Map<String, JsonNode> getMapping();

    abstract boolean hasTermMapping(String var1);

    abstract boolean hasTermMapping(String var1, JsonNode var2);

    abstract boolean isEmpty();

    abstract boolean isRoot();

    public Optional<String> getMappedTerm(String iri) {
        Objects.requireNonNull(iri);
        for (Map.Entry<String, JsonNode> e : this.getMapping().entrySet()) {
            Optional<String> id = TermMappingHolder.extractId(e.getValue());
            if (!id.isPresent() || !iri.equals(id.get())) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    private static Optional<String> extractId(JsonNode node) {
        assert (node instanceof StringLiteralNode || node instanceof ObjectNode);
        if (node instanceof StringLiteralNode) {
            return Optional.of((String)((StringLiteralNode)node).getValue());
        }
        ObjectNode on = (ObjectNode)node;
        return on.getItems().stream().filter(item -> "@id".equals(item.getName())).map(idNode -> (String)((StringLiteralNode)idNode).getValue()).findAny();
    }
}

