/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.model;

import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public abstract class CompositeNode<T extends Collection<JsonNode>>
extends JsonNode {
    final T items = this.initItems();
    private boolean open = true;

    public CompositeNode() {
    }

    public CompositeNode(String name) {
        super(name);
    }

    abstract T initItems();

    public void addItem(JsonNode item) {
        Objects.requireNonNull(item);
        this.items.add((JsonNode)item);
    }

    public void prependItem(JsonNode item) {
        throw new UnsupportedOperationException("Prepending items is not supported by this composite node.");
    }

    public Collection<JsonNode> getItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void close() {
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeNode that = (CompositeNode)o;
        return this.open == that.open && this.items.equals(that.items);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.open);
    }
}

