/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.model;

import cz.cvut.kbss.jsonld.exception.JsonLdSerializationException;
import cz.cvut.kbss.jsonld.serialization.JsonGenerator;
import java.io.IOException;

public abstract class JsonNode {
    private final String name;
    private final boolean valueNode;

    JsonNode() {
        this.name = null;
        this.valueNode = true;
    }

    public JsonNode(String name) {
        this.name = name;
        this.valueNode = name == null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValueNode() {
        return this.valueNode;
    }

    public void write(JsonGenerator writer) {
        try {
            if (!this.valueNode) {
                this.writeKey(writer);
            }
            this.writeValue(writer);
        }
        catch (IOException e) {
            throw new JsonLdSerializationException("Exception during serialization of node " + this, e);
        }
    }

    protected void writeKey(JsonGenerator writer) throws IOException {
        writer.writeFieldName(this.name);
    }

    protected abstract void writeValue(JsonGenerator var1) throws IOException;

    public String toString() {
        return this.name == null ? "{" : "{\"" + this.name + "\": ";
    }
}

