/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer;

import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializers;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class LiteralValueSerializers
implements ValueSerializers {
    private final Map<Class<?>, ValueSerializer<?>> serializers = new HashMap();
    private final ValueSerializer<?> defaultSerializer;
    private ValueSerializer<String> identifierSerializer;
    private ValueSerializer<Set<String>> typesSerializer;
    private ValueSerializer<?> individualSerializer;

    public LiteralValueSerializers(ValueSerializer<?> defaultSerializer) {
        this.defaultSerializer = Objects.requireNonNull(defaultSerializer);
    }

    @Override
    public <T> boolean hasCustomSerializer(Class<T> type) {
        return this.serializers.containsKey(type);
    }

    @Override
    public <T> Optional<ValueSerializer<T>> getSerializer(SerializationContext<T> ctx) {
        return Optional.ofNullable(this.serializers.get(ctx.getValue().getClass()));
    }

    @Override
    public <T> ValueSerializer<T> getOrDefault(SerializationContext<T> ctx) {
        return this.serializers.getOrDefault(ctx.getValue().getClass(), this.defaultSerializer);
    }

    @Override
    public <T> void registerSerializer(Class<T> forType, ValueSerializer<? super T> serializer) {
        Objects.requireNonNull(forType);
        Objects.requireNonNull(serializer);
        this.serializers.put(forType, serializer);
    }

    @Override
    public ValueSerializer<String> getIdentifierSerializer() {
        return this.identifierSerializer;
    }

    @Override
    public void registerIdentifierSerializer(ValueSerializer<String> idSerializer) {
        this.identifierSerializer = Objects.requireNonNull(idSerializer);
    }

    @Override
    public ValueSerializer<Set<String>> getTypesSerializer() {
        return this.typesSerializer;
    }

    @Override
    public void registerTypesSerializer(ValueSerializer<Set<String>> typesSerializer) {
        this.typesSerializer = Objects.requireNonNull(typesSerializer);
    }

    @Override
    public ValueSerializer<?> getIndividualSerializer() {
        return this.individualSerializer;
    }

    @Override
    public void registerIndividualSerializer(ValueSerializer<?> individualSerializer) {
        this.individualSerializer = Objects.requireNonNull(individualSerializer);
    }

    @Override
    public void configure(Configuration configuration) {
        this.serializers.values().forEach(vs -> vs.configure(configuration));
        this.individualSerializer.configure(configuration);
        this.identifierSerializer.configure(configuration);
        this.typesSerializer.configure(configuration);
        this.defaultSerializer.configure(configuration);
    }
}

