/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer;

import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializers;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.ObjectPropertyValueSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ObjectGraphValueSerializers
implements ValueSerializers {
    private final ValueSerializers serializers;
    private final ObjectPropertyValueSerializer opSerializer;

    public ObjectGraphValueSerializers(ValueSerializers serializers, ObjectPropertyValueSerializer opSerializer) {
        this.serializers = Objects.requireNonNull(serializers);
        this.opSerializer = Objects.requireNonNull(opSerializer);
    }

    @Override
    public <T> boolean hasCustomSerializer(Class<T> type) {
        return this.serializers.hasCustomSerializer(type);
    }

    @Override
    public <T> Optional<ValueSerializer<T>> getSerializer(SerializationContext<T> ctx) {
        Optional<ValueSerializer<T>> result = this.serializers.getSerializer(ctx);
        return result.isPresent() ? result : (BeanAnnotationProcessor.isObjectProperty(ctx.getField()) ? Optional.of(this.opSerializer) : Optional.empty());
    }

    @Override
    public <T> ValueSerializer<T> getOrDefault(SerializationContext<T> ctx) {
        Optional<ValueSerializer<ValueSerializer>> result = this.serializers.getSerializer(ctx);
        return result.orElseGet(() -> BeanAnnotationProcessor.isObjectProperty(ctx.getField()) ? this.opSerializer : this.serializers.getOrDefault(ctx));
    }

    @Override
    public <T> void registerSerializer(Class<T> forType, ValueSerializer<? super T> serializer) {
        this.serializers.registerSerializer(forType, serializer);
    }

    @Override
    public ValueSerializer<String> getIdentifierSerializer() {
        return this.serializers.getIdentifierSerializer();
    }

    @Override
    public void registerIdentifierSerializer(ValueSerializer<String> idSerializer) {
        this.serializers.registerIdentifierSerializer(idSerializer);
    }

    @Override
    public ValueSerializer<Set<String>> getTypesSerializer() {
        return this.serializers.getTypesSerializer();
    }

    @Override
    public void registerTypesSerializer(ValueSerializer<Set<String>> typesSerializer) {
        this.serializers.registerTypesSerializer(typesSerializer);
    }

    @Override
    public ValueSerializer<?> getIndividualSerializer() {
        return this.serializers.getIndividualSerializer();
    }

    @Override
    public void registerIndividualSerializer(ValueSerializer<?> individualSerializer) {
        this.serializers.registerIndividualSerializer(individualSerializer);
    }
}

