/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.compact;

import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.model.CollectionNode;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.serializer.SerializerUtils;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.MultilingualStringSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Collection;

public class DefaultValueSerializer
implements ValueSerializer {
    private final MultilingualStringSerializer multilingualStringSerializer;

    public DefaultValueSerializer(MultilingualStringSerializer multilingualStringSerializer) {
        this.multilingualStringSerializer = multilingualStringSerializer;
    }

    public JsonNode serialize(Object value, SerializationContext ctx) {
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            CollectionNode<?> node = JsonNodeFactory.createCollectionNode(ctx.getTerm(), col);
            col.forEach(item -> {
                if (SerializerUtils.isAnnotationReference(item, ctx)) {
                    node.addItem(DefaultValueSerializer.serializeReference(null, item));
                } else if (item instanceof MultilingualString) {
                    node.addItem(this.multilingualStringSerializer.serialize((MultilingualString)item, new SerializationContext<MultilingualString>((MultilingualString)item, ctx.getJsonLdContext())));
                } else {
                    node.addItem(JsonNodeFactory.createLiteralNode(item));
                }
            });
            return node;
        }
        if (SerializerUtils.isAnnotationReference(value, ctx)) {
            return DefaultValueSerializer.serializeReference(ctx.getTerm(), value);
        }
        if (value instanceof MultilingualString) {
            return this.multilingualStringSerializer.serialize((MultilingualString)value, (SerializationContext<MultilingualString>)ctx);
        }
        return JsonNodeFactory.createLiteralNode(ctx.getTerm(), value);
    }

    private static JsonNode serializeReference(String attId, Object value) {
        ObjectNode node = JsonNodeFactory.createObjectNode(attId);
        node.addItem(JsonNodeFactory.createObjectIdNode("@id", value));
        return node;
    }
}

