/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.compact;

import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.common.EnumUtil;
import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;

public class IndividualSerializer
implements ValueSerializer {
    public JsonNode serialize(Object value, SerializationContext ctx) {
        assert (BeanClassProcessor.isIdentifierType(value.getClass()) || value.getClass().isEnum());
        if (BeanClassProcessor.isIdentifierType(value.getClass())) {
            return this.serializeValue(value, ctx);
        }
        assert (value instanceof Enum);
        String iri = EnumUtil.resolveMappedIndividual((Enum)value);
        return this.serialize(iri, ctx);
    }

    private JsonNode serializeValue(Object value, SerializationContext<?> ctx) {
        ObjectNode node = JsonNodeFactory.createObjectNode(ctx.getTerm());
        node.addItem(JsonNodeFactory.createObjectIdNode(this.idAttribute(ctx), value));
        return node;
    }

    private String idAttribute(SerializationContext<?> ctx) {
        return ctx.getJsonLdContext().getMappedTerm("@id").orElse("@id");
    }
}

