/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.compact;

import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.model.SetNode;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Map;

public class MultilingualStringSerializer
implements ValueSerializer<MultilingualString> {
    @Override
    public JsonNode serialize(MultilingualString value, SerializationContext<MultilingualString> ctx) {
        if (value.getValue().size() == 1) {
            Map.Entry entry = value.getValue().entrySet().iterator().next();
            return MultilingualStringSerializer.createNode(ctx.getTerm(), (String)entry.getValue(), (String)entry.getKey());
        }
        SetNode collectionNode = JsonNodeFactory.createCollectionNodeFromArray(ctx.getTerm());
        this.addTranslationsToCollectionNode(value, collectionNode);
        return collectionNode;
    }

    private static JsonNode createNode(String attName, String value, String language) {
        ObjectNode node = JsonNodeFactory.createObjectNode(attName);
        node.addItem(JsonNodeFactory.createLiteralNode("@language", language != null ? language : "@none"));
        node.addItem(JsonNodeFactory.createLiteralNode("@value", value));
        return node;
    }

    private void addTranslationsToCollectionNode(MultilingualString str, SetNode target) {
        str.getValue().forEach((lang, val) -> target.addItem(MultilingualStringSerializer.createNode(null, val, lang)));
    }
}

