/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.compact.datetime;

import cz.cvut.kbss.jsonld.ConfigParam;
import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.exception.UnsupportedTemporalTypeException;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.datetime.EpochBasedDateTimeSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.datetime.IsoDateTimeSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.datetime.LocalDateSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.datetime.TimeSerializer;
import cz.cvut.kbss.jsonld.serialization.serializer.datetime.DateTimeSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;

public class TemporalSerializer
implements ValueSerializer<TemporalAccessor> {
    protected DateTimeSerializer dateTimeSerializer;
    private final LocalDateSerializer dateSerializer;
    private final TimeSerializer timeSerializer;

    public TemporalSerializer() {
        this(new IsoDateTimeSerializer(), new LocalDateSerializer(), new TimeSerializer());
    }

    protected TemporalSerializer(DateTimeSerializer dateTimeSerializer, LocalDateSerializer dateSerializer, TimeSerializer timeSerializer) {
        this.dateTimeSerializer = dateTimeSerializer;
        this.dateSerializer = dateSerializer;
        this.timeSerializer = timeSerializer;
    }

    @Override
    public JsonNode serialize(TemporalAccessor value, SerializationContext<TemporalAccessor> ctx) {
        if (value instanceof LocalDate) {
            return this.dateSerializer.serialize((LocalDate)value, ctx);
        }
        if (value instanceof OffsetTime) {
            return this.timeSerializer.serialize((OffsetTime)value, ctx);
        }
        if (value instanceof LocalTime) {
            return this.timeSerializer.serialize((LocalTime)value, ctx);
        }
        if (value instanceof OffsetDateTime) {
            return this.dateTimeSerializer.serialize((OffsetDateTime)value, ctx);
        }
        if (value instanceof LocalDateTime) {
            return this.dateTimeSerializer.serialize((LocalDateTime)value, ctx);
        }
        if (value instanceof Instant) {
            return this.dateTimeSerializer.serialize((Instant)value, ctx);
        }
        if (value instanceof ZonedDateTime) {
            return this.dateTimeSerializer.serialize(((ZonedDateTime)value).toOffsetDateTime(), ctx);
        }
        throw new UnsupportedTemporalTypeException("Temporal type " + value.getClass() + " serialization is not supported.");
    }

    @Override
    public void configure(Configuration config) {
        assert (config != null);
        this.dateTimeSerializer = config.is(ConfigParam.SERIALIZE_DATETIME_AS_MILLIS) ? new EpochBasedDateTimeSerializer() : new IsoDateTimeSerializer();
        this.dateTimeSerializer.configure(config);
    }
}

