/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.context;

import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.model.CollectionNode;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.serializer.SerializerUtils;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Collection;

public class ContextBuildingDefaultValueSerializer
implements ValueSerializer {
    private final ValueSerializer<MultilingualString> multilingualStringValueSerializer;
    private final ValueSerializer<Collection<MultilingualString>> pluralMultilingualSerializer;

    public ContextBuildingDefaultValueSerializer(ValueSerializer<MultilingualString> multilingualStringValueSerializer, ValueSerializer<Collection<MultilingualString>> pluralMultilingualSerializer) {
        this.multilingualStringValueSerializer = multilingualStringValueSerializer;
        this.pluralMultilingualSerializer = pluralMultilingualSerializer;
    }

    public JsonNode serialize(Object value, SerializationContext ctx) {
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            if (col.isEmpty()) {
                ctx.registerTermMapping(ctx.getFieldName(), ctx.getTerm());
                return JsonNodeFactory.createCollectionNode(ctx.getTerm(), col);
            }
            Object elem = col.iterator().next();
            if (SerializerUtils.isAnnotationReference(elem, ctx)) {
                return ContextBuildingDefaultValueSerializer.serializeReferences(col, ctx);
            }
            if (elem instanceof MultilingualString) {
                return this.pluralMultilingualSerializer.serialize(col, ctx);
            }
            return ContextBuildingDefaultValueSerializer.serializeLiterals(col, ctx);
        }
        if (SerializerUtils.isAnnotationReference(value, ctx)) {
            return ContextBuildingDefaultValueSerializer.serializeReference(value, ctx);
        }
        if (value instanceof MultilingualString) {
            return this.multilingualStringValueSerializer.serialize((MultilingualString)value, ctx);
        }
        if (ctx.getField() != null) {
            ctx.registerTermMapping(ctx.getFieldName(), ctx.getTerm());
        }
        return JsonNodeFactory.createLiteralNode(ctx.getTerm(), value);
    }

    private static JsonNode serializeReferences(Collection<?> elems, SerializationContext<?> ctx) {
        ctx.registerTermMapping(ctx.getFieldName(), ctx.getTerm());
        CollectionNode<?> result = JsonNodeFactory.createCollectionNode(ctx.getTerm(), elems);
        elems.forEach(e -> result.addItem(ContextBuildingDefaultValueSerializer.serializeReference(e, new SerializationContext<Object>(e, ctx.getJsonLdContext()))));
        return result;
    }

    private static JsonNode serializeReference(Object value, SerializationContext<?> ctx) {
        ObjectNode node;
        if (ctx.getTerm() != null) {
            ctx.registerTermMapping(ctx.getFieldName(), ctx.getTerm());
            node = JsonNodeFactory.createObjectNode(ctx.getTerm());
        } else {
            node = JsonNodeFactory.createObjectNode();
        }
        node.addItem(JsonNodeFactory.createLiteralNode("@id", value));
        return node;
    }

    private static JsonNode serializeLiterals(Collection<?> elems, SerializationContext<?> ctx) {
        ctx.registerTermMapping(ctx.getFieldName(), ctx.getTerm());
        CollectionNode<?> result = JsonNodeFactory.createCollectionNode(ctx.getTerm(), elems);
        elems.forEach(e -> result.addItem(JsonNodeFactory.createLiteralNode(e)));
        return result;
    }
}

