/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.context;

import cz.cvut.kbss.jsonld.ConfigParam;
import cz.cvut.kbss.jsonld.Configuration;
import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.serializer.SerializerUtils;
import cz.cvut.kbss.jsonld.serialization.serializer.compact.ObjectPropertyValueSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.ObjectGraphTraverser;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Collection;

public class ContextBuildingObjectPropertyValueSerializer
extends ObjectPropertyValueSerializer {
    private boolean serializeUsingExtendedDefinition;

    public ContextBuildingObjectPropertyValueSerializer(ObjectGraphTraverser graphTraverser) {
        super(graphTraverser);
    }

    @Override
    public JsonNode serialize(Object value, SerializationContext ctx) {
        if (ctx.getTerm() != null) {
            this.registerTermDefinition(ctx);
        }
        return super.serialize(value, ctx);
    }

    private void registerTermDefinition(SerializationContext<?> ctx) {
        if (this.serializeUsingExtendedDefinition && ContextBuildingObjectPropertyValueSerializer.isIndividual(ctx)) {
            ctx.registerTermMapping(ctx.getFieldName(), SerializerUtils.createTypedTermDefinition(ctx.getFieldName(), ctx.getTerm(), "@id"));
        } else {
            ctx.registerTermMapping(ctx.getFieldName(), ctx.getTerm());
        }
    }

    private static boolean isIndividual(SerializationContext<?> ctx) {
        if (BeanClassProcessor.isIndividualType(ctx.getValue().getClass())) {
            return true;
        }
        if (ctx.getValue() instanceof Collection) {
            Collection c = (Collection)ctx.getValue();
            for (Object elem : c) {
                if (elem == null) continue;
                return BeanClassProcessor.isIndividualType(elem.getClass());
            }
        }
        return false;
    }

    @Override
    public void configure(Configuration config) {
        this.serializeUsingExtendedDefinition = config.is(ConfigParam.SERIALIZE_INDIVIDUALS_USING_EXPANDED_DEFINITION);
    }
}

