/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.context;

import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.model.ObjectNode;
import cz.cvut.kbss.jsonld.serialization.model.SetNode;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class ContextBuildingPluralMultilingualStringSerializer
implements ValueSerializer<Collection<MultilingualString>> {
    public ObjectNode serialize(Collection<MultilingualString> value, SerializationContext<Collection<MultilingualString>> ctx) {
        if (ctx.getTerm() != null) {
            ContextBuildingPluralMultilingualStringSerializer.registerTermMapping(ctx);
        }
        HashMap<String, Set> allValues = new HashMap<String, Set>();
        value.forEach(ms -> ms.getValue().forEach((lang, text) -> {
            allValues.putIfAbsent((String)lang, new LinkedHashSet());
            ((Set)allValues.get(lang)).add(text);
        }));
        ObjectNode node = JsonNodeFactory.createObjectNode(ctx.getTerm());
        allValues.forEach((lang, texts) -> {
            String langKey;
            String string = langKey = lang != null ? lang : "@none";
            if (texts.size() == 1) {
                node.addItem(JsonNodeFactory.createLiteralNode(langKey, texts.iterator().next()));
            } else {
                SetNode translations = JsonNodeFactory.createCollectionNodeFromArray(langKey);
                texts.forEach(t -> translations.addItem(JsonNodeFactory.createLiteralNode(t)));
                node.addItem(translations);
            }
        });
        return node;
    }

    static void registerTermMapping(SerializationContext<Collection<MultilingualString>> ctx) {
        ObjectNode mapping = JsonNodeFactory.createObjectNode(ctx.getFieldName());
        mapping.addItem(JsonNodeFactory.createLiteralNode("@id", ctx.getTerm()));
        mapping.addItem(JsonNodeFactory.createLiteralNode("@container", "@language"));
        ctx.registerTermMapping(ctx.getFieldName(), mapping);
    }
}

