/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.serializer.context;

import cz.cvut.kbss.jsonld.serialization.JsonGenerator;
import cz.cvut.kbss.jsonld.serialization.JsonNodeFactory;
import cz.cvut.kbss.jsonld.serialization.model.JsonNode;
import cz.cvut.kbss.jsonld.serialization.model.SetNode;
import cz.cvut.kbss.jsonld.serialization.serializer.ValueSerializer;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;

public class ContextBuildingTypesSerializer
implements ValueSerializer<Set<String>> {
    @Override
    public JsonNode serialize(Set<String> value, SerializationContext<Set<String>> ctx) {
        SetNode typesNode;
        if (ctx.getField() != null) {
            ctx.registerTermMapping(ctx.getFieldName(), "@type");
            typesNode = JsonNodeFactory.createSetNode(ctx.getTerm());
        } else {
            typesNode = new ContextBasedTypesNode(ctx);
        }
        value.forEach(type -> typesNode.addItem(JsonNodeFactory.createLiteralNode(type)));
        return typesNode;
    }

    private static class ContextBasedTypesNode
    extends SetNode {
        private final SerializationContext<Set<String>> ctx;

        private ContextBasedTypesNode(SerializationContext<Set<String>> ctx) {
            super("@type");
            this.ctx = ctx;
        }

        @Override
        protected void writeKey(JsonGenerator writer) throws IOException {
            Optional<String> typesTerm = this.ctx.getMappedTerm("@type");
            if (typesTerm.isPresent()) {
                writer.writeFieldName(typesTerm.get());
            } else {
                super.writeKey(writer);
            }
        }
    }
}

