/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.traversal;

import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.exception.BeanProcessingException;
import cz.cvut.kbss.jsonld.exception.MissingTypeInfoException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

class InstanceTypeResolver {
    InstanceTypeResolver() {
    }

    Set<String> resolveTypes(Object instance) {
        assert (instance != null);
        Set<String> declaredTypes = BeanAnnotationProcessor.getOwlClasses(instance);
        Optional<Field> typesField = BeanAnnotationProcessor.getTypesField(instance.getClass());
        typesField.ifPresent(f -> {
            if (!Collection.class.isAssignableFrom(f.getType())) {
                throw new BeanProcessingException("@Types field in object " + instance + " must be a collection.");
            }
            Collection runtimeTypes = (Collection)BeanClassProcessor.getFieldValue(f, instance);
            if (runtimeTypes != null) {
                runtimeTypes.forEach(t -> declaredTypes.add(t.toString()));
            }
        });
        if (declaredTypes.isEmpty()) {
            throw new MissingTypeInfoException("No type info found on instance " + instance + ". Either annotate the class with @OWLClass or provide a non-empty @Types field. If it is a literal, make sure that the property referencing is not an @OWLObjectProperty");
        }
        return declaredTypes;
    }
}

