/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jsonld.serialization.traversal;

import cz.cvut.kbss.jsonld.common.BeanAnnotationProcessor;
import cz.cvut.kbss.jsonld.common.BeanClassProcessor;
import cz.cvut.kbss.jsonld.common.IdentifierUtil;
import cz.cvut.kbss.jsonld.exception.MissingIdentifierException;
import cz.cvut.kbss.jsonld.serialization.traversal.InstanceTypeResolver;
import cz.cvut.kbss.jsonld.serialization.traversal.InstanceVisitor;
import cz.cvut.kbss.jsonld.serialization.traversal.PropertiesTraverser;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContext;
import cz.cvut.kbss.jsonld.serialization.traversal.SerializationContextFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ObjectGraphTraverser {
    private final SerializationContextFactory serializationContextFactory;
    private InstanceVisitor visitor;
    private final InstanceTypeResolver typeResolver = new InstanceTypeResolver();
    private boolean requireId = false;
    private final Map<Object, String> knownInstances = new IdentityHashMap<Object, String>();

    public ObjectGraphTraverser(SerializationContextFactory serializationContextFactory) {
        this.serializationContextFactory = serializationContextFactory;
    }

    public void setVisitor(InstanceVisitor visitor) {
        this.visitor = Objects.requireNonNull(visitor);
    }

    public void removeVisitor() {
        this.visitor = null;
    }

    public void traverse(Object instance) {
        Objects.requireNonNull(instance);
        this.traverse(this.serializationContextFactory.create(instance));
    }

    public void traverse(SerializationContext<?> ctx) {
        Objects.requireNonNull(ctx);
        assert (this.visitor != null);
        if (ctx.getValue() instanceof Collection) {
            this.traverseCollection(ctx);
        } else {
            this.traverseSingular(ctx);
        }
    }

    private void traverseCollection(SerializationContext<? extends Collection<?>> ctx) {
        this.openCollection(ctx);
        for (Object item : ctx.getValue()) {
            if (item == null) continue;
            this.traverseSingular(this.serializationContextFactory.create(item, ctx));
        }
        this.closeCollection(ctx);
    }

    void traverseSingular(SerializationContext<?> ctx) {
        if (ctx.getValue() == null) {
            return;
        }
        boolean shouldTraverse = this.visitInstance(ctx);
        if (!shouldTraverse) {
            return;
        }
        if (BeanClassProcessor.isIndividualType(ctx.getValue().getClass())) {
            this.visitIndividual(ctx);
            return;
        }
        boolean firstEncounter = !this.knownInstances.containsKey(ctx.getValue());
        this.openInstance(ctx);
        this.visitIdentifier(ctx);
        if (firstEncounter) {
            this.visitTypes(ctx);
            this.serializeFields(ctx);
            this.serializePropertiesField(ctx);
        }
        this.closeInstance(ctx);
    }

    private void serializeFields(SerializationContext<?> ctx) {
        Object instance = ctx.getValue();
        List<Field> fieldsToSerialize = this.orderAttributesForSerialization(BeanAnnotationProcessor.getSerializableFields(instance), BeanAnnotationProcessor.getAttributeOrder(instance.getClass()));
        for (Field f : fieldsToSerialize) {
            if (this.shouldSkipFieldSerialization(f)) continue;
            Object value = BeanClassProcessor.getFieldValue(f, instance);
            SerializationContext<Object> fieldCtx = this.serializationContextFactory.createForAttribute(f, value, ctx);
            this.visitAttribute(fieldCtx);
        }
    }

    private boolean shouldSkipFieldSerialization(Field f) {
        return BeanAnnotationProcessor.isInstanceIdentifier(f) || BeanAnnotationProcessor.isPropertiesField(f) || BeanAnnotationProcessor.isTypesField(f);
    }

    private List<Field> orderAttributesForSerialization(List<Field> fields, String[] ordering) {
        ArrayList<Field> result = new ArrayList<Field>(fields.size());
        block0: for (String item : ordering) {
            Iterator<Field> it = fields.iterator();
            while (it.hasNext()) {
                Field f = it.next();
                if (!f.getName().equals(item)) continue;
                it.remove();
                result.add(f);
                continue block0;
            }
        }
        result.addAll(fields);
        return result;
    }

    private void serializePropertiesField(SerializationContext<?> ctx) {
        Object instance = ctx.getValue();
        if (!BeanAnnotationProcessor.hasPropertiesField(instance.getClass())) {
            return;
        }
        Field propertiesField = BeanAnnotationProcessor.getPropertiesField(instance.getClass());
        Object value = BeanClassProcessor.getFieldValue(propertiesField, instance);
        if (value == null) {
            return;
        }
        assert (value instanceof Map);
        new PropertiesTraverser(this).traverseProperties(this.serializationContextFactory.createForProperties(propertiesField, (Map)value, ctx));
    }

    public boolean visitInstance(SerializationContext<?> ctx) {
        return this.visitor.visitObject(ctx);
    }

    public void visitIndividual(SerializationContext<?> ctx) {
        this.visitor.visitIndividual(ctx);
    }

    public void openInstance(SerializationContext<?> ctx) {
        if (!BeanClassProcessor.isIdentifierType(ctx.getValue().getClass())) {
            String identifier = this.resolveIdentifier(ctx.getValue());
            this.knownInstances.put(ctx.getValue(), identifier);
        }
        this.visitor.openObject(ctx);
    }

    private String resolveIdentifier(Object instance) {
        Optional<Object> extractedId = BeanAnnotationProcessor.getInstanceIdentifier(instance);
        if (!extractedId.isPresent() && this.requireId) {
            throw MissingIdentifierException.create(instance);
        }
        return extractedId.orElseGet(() -> this.knownInstances.containsKey(instance) ? this.knownInstances.get(instance) : IdentifierUtil.generateBlankNodeId()).toString();
    }

    public void closeInstance(SerializationContext<?> ctx) {
        this.visitor.closeObject(ctx);
    }

    public void visitIdentifier(SerializationContext<?> ctx) {
        Object identifier = ctx.getValue();
        Class<?> idCls = identifier.getClass();
        String id = this.resolveIdentifier(identifier);
        SerializationContext<String> idContext = this.serializationContextFactory.createForIdentifier(BeanAnnotationProcessor.getIdentifierField(idCls).orElse(null), id, ctx);
        this.knownInstances.put(identifier, id);
        this.visitor.visitIdentifier(idContext);
    }

    public void visitTypes(SerializationContext<?> ctx) {
        Object instance = ctx.getValue();
        Set<String> resolvedTypes = this.typeResolver.resolveTypes(instance);
        assert (!resolvedTypes.isEmpty());
        SerializationContext<Set<String>> typesContext = this.serializationContextFactory.createForTypes(BeanAnnotationProcessor.getTypesField(instance.getClass()).orElse(null), resolvedTypes, ctx);
        this.visitor.visitTypes(typesContext);
    }

    public void visitAttribute(SerializationContext<?> ctx) {
        this.visitor.visitAttribute(ctx);
    }

    public void openCollection(SerializationContext<? extends Collection<?>> ctx) {
        this.visitor.openCollection(ctx);
    }

    public void closeCollection(SerializationContext<?> ctx) {
        this.visitor.closeCollection(ctx);
    }

    public void setRequireId(boolean requireId) {
        this.requireId = requireId;
    }
}

